/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.metrics.integration;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import java.util.ArrayList;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.metrics.Interceptor.MeterCounterInterceptor;
import org.noear.solon.cloud.metrics.Interceptor.MeterGaugeInterceptor;
import org.noear.solon.cloud.metrics.Interceptor.MeterSummaryInterceptor;
import org.noear.solon.cloud.metrics.Interceptor.MeterTimerInterceptor;
import org.noear.solon.cloud.metrics.annotation.MeterCounter;
import org.noear.solon.cloud.metrics.annotation.MeterGauge;
import org.noear.solon.cloud.metrics.annotation.MeterSummary;
import org.noear.solon.cloud.metrics.annotation.MeterTimer;
import org.noear.solon.cloud.metrics.integration.CloudMetricServiceImpl;
import org.noear.solon.cloud.service.CloudMetricService;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.aspect.Interceptor;

public class XPluginImpl
implements Plugin {
    public void start(AopContext context) {
        context.beanInterceptorAdd(MeterCounter.class, (Interceptor)new MeterCounterInterceptor());
        context.beanInterceptorAdd(MeterGauge.class, (Interceptor)new MeterGaugeInterceptor());
        context.beanInterceptorAdd(MeterSummary.class, (Interceptor)new MeterSummaryInterceptor());
        context.beanInterceptorAdd(MeterTimer.class, (Interceptor)new MeterTimerInterceptor());
        context.wrapAndPut(MeterRegistry.class, (Object)Metrics.globalRegistry);
        context.subBeansOfType(MeterRegistry.class, bean -> {
            if (bean != Metrics.globalRegistry) {
                Metrics.addRegistry((MeterRegistry)bean);
            }
        });
        this.meterCommonTagsInit();
        CloudManager.register((CloudMetricService)new CloudMetricServiceImpl());
    }

    private void meterCommonTagsInit() {
        ArrayList<Tag> commonTags = new ArrayList<Tag>();
        if (Utils.isNotEmpty((String)Solon.cfg().appName())) {
            commonTags.add(Tag.of((String)"solon.app.name", (String)Solon.cfg().appName()));
        }
        if (Utils.isNotEmpty((String)Solon.cfg().appGroup())) {
            commonTags.add(Tag.of((String)"solon.app.group", (String)Solon.cfg().appGroup()));
        }
        if (Utils.isNotEmpty((String)Solon.cfg().appNamespace())) {
            commonTags.add(Tag.of((String)"solon.app.nameSpace", (String)Solon.cfg().appNamespace()));
        }
        if (commonTags.size() > 0) {
            Metrics.globalRegistry.config().commonTags(commonTags);
        }
    }
}

