/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.metrics.Interceptor;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.TimeUnit;
import org.noear.solon.Utils;
import org.noear.solon.cloud.metrics.Interceptor.BaseMeterInterceptor;
import org.noear.solon.cloud.metrics.annotation.MeterTimer;
import org.noear.solon.core.aspect.Invocation;

public class MeterTimerInterceptor
extends BaseMeterInterceptor<MeterTimer, Timer> {
    @Override
    protected MeterTimer getAnno(Invocation inv) {
        MeterTimer anno = (MeterTimer)inv.method().getAnnotation(MeterTimer.class);
        if (anno == null) {
            anno = inv.target().getClass().getAnnotation(MeterTimer.class);
        }
        return anno;
    }

    @Override
    protected String getAnnoName(MeterTimer anno) {
        return Utils.annoAlias((String)anno.value(), (String)anno.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object metering(Invocation inv, MeterTimer anno) throws Throwable {
        Timer meter = (Timer)this.meterCached.get(anno);
        if (meter == null) {
            MeterTimer meterTimer = anno;
            synchronized (meterTimer) {
                meter = (Timer)this.meterCached.get(anno);
                if (meter == null) {
                    String meterName = this.getMeterName(inv, anno);
                    meter = Metrics.timer((String)meterName, (Iterable)this.getMeterTags(inv, anno.tags()));
                    this.meterCached.put(anno, meter);
                }
            }
        }
        long start = System.currentTimeMillis();
        try {
            Object object = inv.invoke();
            return object;
        }
        finally {
            long span = System.currentTimeMillis() - start;
            meter.record(span, TimeUnit.MICROSECONDS);
        }
    }
}

