/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.metrics.Interceptor;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Metrics;
import java.util.HashMap;
import java.util.Map;
import org.noear.snack.core.utils.StringUtil;
import org.noear.solon.cloud.metrics.TagUtil;
import org.noear.solon.cloud.metrics.annotation.MeterCounter;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.Invocation;

public class MeterCounterInterceptor
implements Interceptor {
    static final Map<String, Counter> counterCache = new HashMap<String, Counter>();

    public Object doIntercept(Invocation inv) throws Throwable {
        MeterCounter anno = inv.target().getClass().getAnnotation(MeterCounter.class);
        if (anno == null) {
            anno = (MeterCounter)inv.method().getAnnotation(MeterCounter.class);
        }
        Object rst = inv.invoke();
        if (anno != null && anno.enable()) {
            if (!counterCache.containsKey(anno.value())) {
                String counterName = anno.value();
                if (StringUtil.isEmpty((String)anno.value())) {
                    counterName = inv.target().getClass() + "." + inv.method().toString();
                }
                Counter counter = Metrics.globalRegistry.counter(counterName, TagUtil.tags(inv, anno.type(), anno.tags()));
                counterCache.put(anno.value(), counter);
            }
            counterCache.get(anno.value()).increment();
        }
        return rst;
    }
}

