/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.noear.solon.Utils;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExFilter;
import org.noear.solon.cloud.gateway.exchange.ExPredicate;
import org.noear.solon.cloud.gateway.properties.TimeoutProperties;
import org.noear.solon.cloud.gateway.route.RouteFactoryManager;
import org.noear.solon.core.util.RankEntity;

public class Route {
    private final String id;
    private URI target;
    private List<ExPredicate> predicates = new ArrayList<ExPredicate>();
    private List<RankEntity<ExFilter>> filters = new ArrayList<RankEntity<ExFilter>>();
    private TimeoutProperties timeout;

    public Route(String id) {
        this.id = id;
        if (Utils.isEmpty((String)id)) {
            throw new IllegalArgumentException("Gateway route id is empty");
        }
    }

    public Route target(URI uri) {
        this.target = uri;
        return this;
    }

    public Route target(String uri) {
        return this.target(URI.create(uri));
    }

    public Route timeout(TimeoutProperties timeout) {
        this.timeout = timeout;
        return this;
    }

    public Route filter(ExFilter filter) {
        return this.filter(filter, 0);
    }

    public Route filters(Collection<ExFilter> filters) {
        for (ExFilter filter : filters) {
            this.filter(filter, 0);
        }
        return this;
    }

    public Route filter(ExFilter filter, int index) {
        if (filter != null) {
            this.filters.add((RankEntity<ExFilter>)new RankEntity((Object)filter, index));
            this.filters.sort(Comparator.comparingInt(e -> e.index));
        }
        return this;
    }

    public Route predicate(ExPredicate predicate) {
        if (predicate != null) {
            this.predicates.add(predicate);
        }
        return this;
    }

    public Route path(String path) {
        ExPredicate predicate = RouteFactoryManager.getPredicate("Path", path);
        return this.predicate(predicate);
    }

    public boolean matched(ExContext ctx) {
        if (this.predicates.size() == 0) {
            return false;
        }
        for (ExPredicate p : this.predicates) {
            if (p.test(ctx)) continue;
            return false;
        }
        return true;
    }

    public String getId() {
        return this.id;
    }

    public URI getTarget() {
        return this.target;
    }

    public List<ExPredicate> getPredicates() {
        return this.predicates;
    }

    public List<RankEntity<ExFilter>> getFilters() {
        return this.filters;
    }

    public TimeoutProperties getTimeout() {
        return this.timeout;
    }
}

