/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import java.util.Map;
import org.noear.solon.cloud.gateway.CloudGatewayCompletion;
import org.noear.solon.cloud.gateway.CloudGatewayConfiguration;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExContextImpl;
import org.noear.solon.cloud.gateway.exchange.ExFilterChainImpl;
import org.noear.solon.cloud.gateway.route.Route;
import org.noear.solon.core.exception.StatusException;
import org.noear.solon.rx.Completable;
import org.reactivestreams.Subscriber;

public class CloudGateway
implements Handler<HttpServerRequest> {
    private CloudGatewayConfiguration configuration = new CloudGatewayConfiguration();

    public void handle(HttpServerRequest request) {
        ExContextImpl ctx = new ExContextImpl(request);
        CloudGatewayCompletion completion = new CloudGatewayCompletion(ctx, request);
        try {
            new ExFilterChainImpl(this.configuration.filters, this::doHandle).doFilter(ctx).subscribe((Subscriber)completion);
        }
        catch (Throwable ex) {
            if (ex instanceof StatusException) {
                StatusException se = (StatusException)ex;
                ctx.newResponse().status(se.getCode());
            } else {
                ctx.newResponse().status(502);
            }
            completion.postComplete();
        }
    }

    private Completable doHandle(ExContext ctx) {
        Route route = this.findRoute(ctx);
        if (route == null) {
            ctx.newResponse().status(404);
            return Completable.complete();
        }
        try {
            return new ExFilterChainImpl(route.getFilters(), this.configuration.routeHandler::handle).doFilter(ctx);
        }
        catch (Throwable ex) {
            if (ex instanceof StatusException) {
                return Completable.error((Throwable)ex);
            }
            return Completable.error((Throwable)new StatusException(ex, 400));
        }
    }

    private Route findRoute(ExContext ctx) {
        for (Map.Entry<String, Route> kv : this.configuration.routes.entrySet()) {
            if (!kv.getValue().matched(ctx)) continue;
            ((ExContextImpl)ctx).bind(kv.getValue());
            return kv.getValue();
        }
        return null;
    }

    public CloudGatewayConfiguration getConfiguration() {
        return this.configuration;
    }
}

