/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route.filter;

import java.util.Arrays;
import java.util.List;
import org.noear.solon.cloud.gateway.exchange.ExContext;
import org.noear.solon.cloud.gateway.exchange.ExFilter;
import org.noear.solon.cloud.gateway.exchange.ExFilterChain;
import org.noear.solon.cloud.gateway.route.RouteFilterFactory;
import reactor.core.publisher.Mono;

public class StripPrefixFilterFactory
implements RouteFilterFactory {
    @Override
    public String prefix() {
        return "StripPrefix";
    }

    @Override
    public ExFilter create(String config) {
        return new StripPrefixFilter(config);
    }

    public static class StripPrefixFilter
    implements ExFilter {
        private int parts;

        public StripPrefixFilter(String config) {
            this.parts = Integer.parseInt(config);
        }

        @Override
        public Mono<Void> doFilter(ExContext ctx, ExFilterChain chain) {
            List<String> pathFragments = Arrays.asList(ctx.newRequest().getPath().split("/", -1));
            String newPath = "/" + String.join((CharSequence)"/", pathFragments.subList(this.parts + 1, pathFragments.size()));
            ctx.newRequest().path(newPath);
            return chain.doFilter(ctx);
        }
    }
}

