/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.route;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.util.KeyValues;

public class RouteRequest {
    public static final String ATTR_NAME = "cloud-upstream-request";
    private String method;
    private String queryString;
    private String path;
    private Map<String, KeyValues<String>> headers = new LinkedHashMap<String, KeyValues<String>>();
    private String contentType;
    private InputStream body;

    public static RouteRequest of(Context ctx) {
        return (RouteRequest)ctx.attr(ATTR_NAME);
    }

    public RouteRequest method(String method) {
        this.method = method;
        return this;
    }

    public RouteRequest path(String path) {
        this.path = path;
        return this;
    }

    public RouteRequest queryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    private KeyValues<String> getHeaderHolder(String key) {
        return this.headers.computeIfAbsent(key, k -> new KeyValues(key));
    }

    public RouteRequest header(String key, String ... values) {
        this.getHeaderHolder(key).setValues((Object[])values);
        return this;
    }

    public RouteRequest header(String key, List<String> values) {
        this.getHeaderHolder(key).setValues((Object[])values.toArray(new String[values.size()]));
        return this;
    }

    public RouteRequest headerAdd(String key, String value) {
        this.getHeaderHolder(key).addValue((Object)value);
        return this;
    }

    public RouteRequest body(InputStream body, String contentType) {
        this.body = body;
        this.contentType = contentType;
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getPath() {
        return this.path;
    }

    public String getPathAndQueryString() {
        if (Utils.isEmpty((String)this.queryString)) {
            return this.path;
        }
        return this.path + "?" + this.queryString;
    }

    public Map<String, KeyValues<String>> getHeaders() {
        return this.headers;
    }

    public String getContentType() {
        return this.contentType;
    }

    public InputStream getBody() {
        return this.body;
    }
}

