/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.gateway.integration;

import java.net.URI;
import org.noear.solon.Solon;
import org.noear.solon.cloud.gateway.CloudGateway;
import org.noear.solon.cloud.gateway.CloudGatewayConfiguration;
import org.noear.solon.cloud.gateway.CloudGatewayFilter;
import org.noear.solon.cloud.gateway.CloudRouteHandler;
import org.noear.solon.cloud.gateway.integration.GatewayProperties;
import org.noear.solon.cloud.gateway.integration.RouteProperties;
import org.noear.solon.cloud.gateway.route.Route;
import org.noear.solon.cloud.gateway.route.RouteFilter;
import org.noear.solon.cloud.gateway.route.RoutePredicate;
import org.noear.solon.cloud.gateway.route.filter.StripPrefixFilter;
import org.noear.solon.cloud.gateway.route.redicate.PathPredicate;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Props;
import org.noear.solon.core.event.AppLoadEndEvent;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.web.reactive.RxFilter;

public class XPluginImpl
implements Plugin {
    public void start(AppContext context) throws Throwable {
        CloudGateway cloudGateway = new CloudGateway();
        context.wrapAndPut(CloudGatewayConfiguration.class, (Object)cloudGateway.getConfiguration());
        this.loadConfiguration(cloudGateway.getConfiguration(), "solon.cloud.gateway");
        context.subWrapsOfType(CloudGatewayFilter.class, bw -> cloudGateway.getConfiguration().filter((RxFilter)bw.raw(), bw.index()));
        context.getBeanAsync(CloudRouteHandler.class, b -> cloudGateway.getConfiguration().routeHandler((CloudRouteHandler)b));
        Solon.app().onEvent(AppLoadEndEvent.class, e -> e.app().http("/**", (Handler)cloudGateway));
    }

    public void loadConfiguration(CloudGatewayConfiguration configuration, String keyStarts) {
        Props props = Solon.cfg().getProp(keyStarts);
        if (props.size() == 0) {
            return;
        }
        GatewayProperties configModel = (GatewayProperties)props.getBean(GatewayProperties.class);
        for (RouteProperties rm : configModel.getRoutes()) {
            Route route = new Route();
            route.id(rm.getId());
            route.target(URI.create(rm.getTarget()));
            if (rm.getPredicates() != null) {
                for (String predicateStr : rm.getPredicates()) {
                    route.predicate(this.buildPredicate(predicateStr));
                }
            }
            if (rm.getFilters() != null) {
                for (String filterStr : rm.getFilters()) {
                    route.filter(this.buildFilter(filterStr));
                }
            }
            configuration.route(route);
        }
        if (configModel.getRouteHandler() != null) {
            configuration.routeHandler(configModel.getRouteHandler());
        }
        for (RxFilter rf : configModel.getFilters()) {
            configuration.filter(rf);
        }
    }

    private RoutePredicate buildPredicate(String predicate) {
        RoutePredicate routePredicate = null;
        int idx = predicate.indexOf(61);
        if (idx > 0) {
            String label = predicate.substring(0, idx);
            String config = predicate.substring(idx + 1, predicate.length());
            if ("Path".equals(label)) {
                routePredicate = new PathPredicate();
            } else if (label.indexOf(46) > 0) {
                routePredicate = (RoutePredicate)ClassUtil.tryInstance((String)label);
            }
            if (routePredicate != null) {
                routePredicate.init(config);
            }
        }
        return routePredicate;
    }

    private RouteFilter buildFilter(String filter) {
        RouteFilter routeFilter = null;
        int idx = filter.indexOf(61);
        if (idx > 0) {
            String label = filter.substring(0, idx);
            String config = filter.substring(idx + 1, filter.length());
            if ("StripPrefix".equals(label)) {
                routeFilter = new StripPrefixFilter();
            } else if (label.indexOf(46) > 0) {
                routeFilter = (RouteFilter)ClassUtil.tryInstance((String)label);
            }
            if (routeFilter != null) {
                routeFilter.init(config);
            }
        }
        return routeFilter;
    }
}

