/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cache.spymemcached;

import java.io.IOException;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import net.spy.memcached.AddrUtil;
import net.spy.memcached.ConnectionFactoryBuilder;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.auth.PlainCallbackHandler;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.data.cache.CacheService;

public class MemCacheService
implements CacheService {
    protected String _cacheKeyHead;
    protected int _defaultSeconds;
    protected final MemcachedClient client;

    public MemCacheService(MemcachedClient client, int defSeconds) {
        this(client, null, defSeconds);
    }

    public MemCacheService(MemcachedClient client, String keyHeader, int defSeconds) {
        this.client = client;
        if (Utils.isEmpty((String)keyHeader)) {
            keyHeader = Solon.cfg().appName();
        }
        if (defSeconds < 1) {
            defSeconds = 30;
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
    }

    public MemCacheService(Properties prop) {
        this(prop, prop.getProperty("keyHeader"), 0);
    }

    public MemCacheService(Properties prop, String keyHeader, int defSeconds) {
        String defSeconds_str = prop.getProperty("defSeconds");
        String server = prop.getProperty("server");
        String user = prop.getProperty("user");
        String password = prop.getProperty("password");
        if (defSeconds == 0 && Utils.isNotEmpty((String)defSeconds_str)) {
            defSeconds = Integer.parseInt(defSeconds_str);
        }
        if (Utils.isEmpty((String)keyHeader)) {
            keyHeader = Solon.cfg().appName();
        }
        if (defSeconds < 1) {
            defSeconds = 30;
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
        ConnectionFactoryBuilder builder = new ConnectionFactoryBuilder();
        builder.setProtocol(ConnectionFactoryBuilder.Protocol.BINARY);
        try {
            if (Utils.isNotEmpty((String)user) && Utils.isNotEmpty((String)password)) {
                AuthDescriptor ad = new AuthDescriptor(new String[]{"PLAIN"}, (CallbackHandler)new PlainCallbackHandler(user, password));
                builder.setAuthDescriptor(ad);
            }
            this.client = new MemcachedClient(builder.build(), AddrUtil.getAddresses((String)server));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public MemcachedClient client() {
        return this.client;
    }

    public void store(String key, Object obj, int seconds) {
        if (obj == null) {
            return;
        }
        if (seconds < 1) {
            seconds = this._defaultSeconds;
        }
        String newKey = this.newKey(key);
        try {
            this.client.set(newKey, seconds, obj);
        }
        catch (Exception e) {
            EventBus.pushTry((Object)e);
        }
    }

    public Object get(String key) {
        String newKey = this.newKey(key);
        try {
            return this.client.get(newKey);
        }
        catch (Exception e) {
            EventBus.pushTry((Object)e);
            return null;
        }
    }

    public void remove(String key) {
        String newKey = this.newKey(key);
        this.client.delete(newKey);
    }

    protected String newKey(String key) {
        return this._cacheKeyHead + "$" + Utils.md5((String)key);
    }
}

