/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cache.redisson;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cache.redisson.RedissonBuilder;
import org.noear.solon.data.cache.CacheService;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedissonCacheService
implements CacheService {
    static final Logger log = LoggerFactory.getLogger(RedissonCacheService.class);
    protected String _cacheKeyHead;
    protected int _defaultSeconds;
    protected final RedissonClient client;

    public RedissonCacheService(RedissonClient client, int defSeconds) {
        this(client, null, defSeconds);
    }

    public RedissonCacheService(RedissonClient client, String keyHeader, int defSeconds) {
        this.client = client;
        if (Utils.isEmpty((String)keyHeader)) {
            keyHeader = Solon.cfg().appName();
        }
        if (defSeconds < 1) {
            defSeconds = 30;
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
    }

    public RedissonCacheService(Properties prop) {
        this(prop, prop.getProperty("keyHeader"), 0);
    }

    public RedissonCacheService(Properties prop, String keyHeader, int defSeconds) {
        String defSeconds_str;
        if (defSeconds == 0 && Utils.isNotEmpty((String)(defSeconds_str = prop.getProperty("defSeconds")))) {
            defSeconds = Integer.parseInt(defSeconds_str);
        }
        if (Utils.isEmpty((String)keyHeader)) {
            keyHeader = Solon.cfg().appName();
        }
        if (defSeconds < 1) {
            defSeconds = 30;
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
        this.client = RedissonBuilder.build(prop);
    }

    public RedissonClient client() {
        return this.client;
    }

    public void store(String key, Object obj, int seconds) {
        if (obj == null) {
            return;
        }
        if (seconds < 1) {
            seconds = this._defaultSeconds;
        }
        String newKey = this.newKey(key);
        try {
            this.client.getBucket(newKey).set(obj, (long)seconds, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    public Object get(String key) {
        String newKey = this.newKey(key);
        return this.client.getBucket(newKey).get();
    }

    public void remove(String key) {
        String newKey = this.newKey(key);
        this.client.getBucket(newKey).delete();
    }

    protected String newKey(String key) {
        return this._cacheKeyHead + ":" + Utils.md5((String)key);
    }
}

