/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cache.caffeine;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.data.cache.CacheService;

public class CaffeineCacheService
implements CacheService {
    private String _cacheKeyHead;
    private int _defaultSeconds;
    private Cache<String, Object> _data;

    public CaffeineCacheService(Properties prop) {
        this(prop, prop.getProperty("keyHeader"), 0);
    }

    public CaffeineCacheService(Properties prop, String keyHeader, int defSeconds) {
        String defSeconds_str = prop.getProperty("defSeconds");
        if (defSeconds == 0 && Utils.isNotEmpty((String)defSeconds_str)) {
            defSeconds = Integer.parseInt(defSeconds_str);
        }
        if (Utils.isEmpty((String)keyHeader)) {
            keyHeader = Solon.cfg().appName();
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
        if (this._defaultSeconds < 1) {
            this._defaultSeconds = 30;
        }
        if (Utils.isEmpty((String)this._cacheKeyHead)) {
            this._cacheKeyHead = Solon.cfg().appName();
        }
        this._data = Caffeine.newBuilder().expireAfterWrite((long)this._defaultSeconds, TimeUnit.SECONDS).build();
    }

    public void store(String key, Object obj, int seconds) {
        this._data.put((Object)key, obj);
    }

    public void remove(String key) {
        this._data.put((Object)key, null);
    }

    public Object get(String key) {
        return this._data.getIfPresent((Object)key);
    }

    public <T> T getOrStore(String key, int seconds, Supplier supplier) {
        return (T)this._data.get((Object)key, arg_0 -> CaffeineCacheService.lambda$getOrStore$0((Supplier)supplier, arg_0));
    }

    private static /* synthetic */ Object lambda$getOrStore$0(Supplier supplier, String k) {
        return supplier.get();
    }
}

