/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.websocket;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.noear.solon.boot.websocket.WebSocketImpl;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsServer
extends WebSocketServer {
    static final Logger log = LoggerFactory.getLogger(WsServer.class);
    private final WebSocketRouter webSocketRouter = WebSocketRouter.getInstance();

    public WsServer(int port) {
        super(new InetSocketAddress(port));
    }

    public WsServer(InetAddress address, int port) {
        super(new InetSocketAddress(address, port));
    }

    public void onStart() {
        LogUtil.global().info("Server:Websocket onStart...");
    }

    private WebSocketImpl getSession(WebSocket conn) {
        return this.getSession(conn, null);
    }

    private WebSocketImpl getSession(WebSocket conn, ClientHandshake shake) {
        WebSocketImpl session = (WebSocketImpl)((Object)conn.getAttachment());
        if (session == null) {
            session = new WebSocketImpl(conn);
            conn.setAttachment((Object)session);
            if (shake != null) {
                Iterator httpFields = shake.iterateHttpFields();
                while (httpFields.hasNext()) {
                    String name = (String)httpFields.next();
                    session.param(name, shake.getFieldValue(name));
                }
            }
        }
        return session;
    }

    public void onOpen(WebSocket conn, ClientHandshake shake) {
        WebSocketImpl webSocket = this.getSession(conn, shake);
        this.webSocketRouter.getListener().onOpen((org.noear.solon.net.websocket.WebSocket)webSocket);
    }

    public void onClose(WebSocket conn, int i, String s, boolean b) {
        WebSocketImpl webSocket = this.getSession(conn);
        if (webSocket.isClosed()) {
            return;
        }
        webSocket.close();
        this.webSocketRouter.getListener().onClose((org.noear.solon.net.websocket.WebSocket)webSocket);
    }

    public void onMessage(WebSocket conn, String data) {
        try {
            WebSocketImpl webSocket = this.getSession(conn);
            this.webSocketRouter.getListener().onMessage((org.noear.solon.net.websocket.WebSocket)webSocket, data);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    public void onMessage(WebSocket conn, ByteBuffer data) {
        try {
            WebSocketImpl webSocket = this.getSession(conn);
            this.webSocketRouter.getListener().onMessage((org.noear.solon.net.websocket.WebSocket)webSocket, data);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    public void onError(WebSocket conn, Exception ex) {
        try {
            WebSocketImpl webSocket = this.getSession(conn);
            this.webSocketRouter.getListener().onError((org.noear.solon.net.websocket.WebSocket)webSocket, (Throwable)ex);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }
}

