/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.websocket;

import java.net.Inet4Address;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.prop.impl.WebSocketServerProps;
import org.noear.solon.boot.websocket.WsServer;
import org.noear.solon.boot.websocket._SessionManagerImpl;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.util.LogUtil;
import org.noear.solon.socketd.SessionManager;

public class XPluginImp
implements Plugin {
    private static Signal _signal;
    private WsServer _server = null;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "org.java_websocket 1.5.0/" + Solon.cfg().version();
    }

    public void start(AopContext context) {
        SessionManager.register((SessionManager)new _SessionManagerImpl());
        if (!Solon.app().enableWebSocket()) {
            return;
        }
        context.beanOnloaded(ctx -> {
            try {
                this.start0(Solon.app());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private void start0(SolonApp app) throws Throwable {
        ServerProps.init();
        WebSocketServerProps props = new WebSocketServerProps(10000);
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        long time_start = System.currentTimeMillis();
        LogUtil.global().info("Server:main: org.java_websocket 1.5.0(websocket)");
        this._server = Utils.isEmpty((String)_host) ? new WsServer(_port) : new WsServer(Inet4Address.getByName(_host), _port);
        this._server.start();
        _signal = new SignalSim(_name, _host, _port, "ws", SignalType.WEBSOCKET);
        app.signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        LogUtil.global().info("Connector:main: websocket: Started ServerConnector@{HTTP/1.1,[WebSocket]}{0.0.0.0:" + _port + "}");
        LogUtil.global().info("Server:main: websocket: Started @" + (time_end - time_start) + "ms");
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
            LogUtil.global().info("Server:main: websocket: Has Stopped " + XPluginImp.solon_boot_ver());
        }
    }
}

