/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.websocket;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;

public class WsRequest {
    private Map<String, Object> _message;
    private String requestId;
    private Map<String, String> params;
    private Map<String, String> headers;
    private ByteArrayInputStream body;
    private InetSocketAddress remoteAddr;

    public WsRequest(Map<String, Object> message) {
        this._message = message;
        this.requestId = (String)message.get("request_id");
        this.params = this._message.containsKey("params") ? (Map<Object, Object>)this._message.get("params") : new HashMap<String, String>();
        this.headers = this._message.containsKey("headers") ? (Map<Object, Object>)this._message.get("headers") : new HashMap<String, String>();
        if (this._message.containsKey("body")) {
            this.body = new ByteArrayInputStream((byte[])this._message.get("body"));
        }
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getRequestUrl() {
        return (String)this._message.get("request_url");
    }

    public String getProtocol() {
        return (String)this._message.get("protocol");
    }

    public String getMethod() {
        return (String)this._message.get("method");
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public InputStream getBody() {
        return this.body;
    }

    public void paramSet(String key, String val) {
        this.params.put(key, val);
    }

    public String param(String key) {
        return this.params.get(key);
    }

    public void headerSet(String key, String val) {
        this.headers.put(key, val);
    }

    public String header(String key) {
        return this.headers.get(key);
    }

    public void setRemoteAddr(InetSocketAddress remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public InetSocketAddress getRemoteAddr() {
        return this.remoteAddr;
    }
}

