/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow.websocket;

import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSocketFrameType;
import io.undertow.websockets.core.WebSockets;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.noear.solon.Solon;
import org.noear.solon.boot.undertow.websocket._SocketServerSession;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.socketd.ProtocolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Pooled;

public class UtWsChannelListener
extends AbstractReceiveListener {
    static final Logger log = LoggerFactory.getLogger(UtWsChannelListener.class);

    public void handleEvent(WebSocketChannel channel) {
        try {
            StreamSourceFrameChannel result = (StreamSourceFrameChannel)channel.receive();
            if (result == null) {
                if (!channel.isOpen()) {
                    this.onClose(channel, result);
                }
                return;
            }
            if (result.getType() == WebSocketFrameType.BINARY) {
                this.onBinary(channel, result);
            } else if (result.getType() == WebSocketFrameType.TEXT) {
                this.onText(channel, result);
            } else if (result.getType() == WebSocketFrameType.PONG) {
                this.onPong(channel, result);
            } else if (result.getType() == WebSocketFrameType.PING) {
                this.onPing(channel, result);
            } else if (result.getType() == WebSocketFrameType.CLOSE) {
                this.onClose(channel, result);
            }
        }
        catch (IOException var3) {
            this.onError(channel, var3);
        }
    }

    public void onOpen(WebSocketHttpExchange exchange, WebSocketChannel channel) {
        Session session = _SocketServerSession.get(channel);
        exchange.getRequestHeaders().forEach((k, v) -> {
            if (v.size() > 0) {
                session.headerSet(k, (String)v.get(0));
            }
        });
        Solon.app().listener().onOpen(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage msg) throws IOException {
        try {
            Pooled pulledData = msg.getData();
            try {
                ByteBuffer[] resource = (ByteBuffer[])pulledData.getResource();
                ByteBuffer byteBuffer = WebSockets.mergeBuffers((ByteBuffer[])resource);
                Session session = _SocketServerSession.get(channel);
                Message message = null;
                message = Solon.app().enableWebSocketD() ? ProtocolManager.decode((ByteBuffer)byteBuffer) : Message.wrap((String)channel.getUrl(), null, (byte[])byteBuffer.array());
                Solon.app().listener().onMessage(session, message);
            }
            finally {
                pulledData.discard();
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage msg) throws IOException {
        try {
            Session session = _SocketServerSession.get(channel);
            Message message = Message.wrap((String)channel.getUrl(), null, (String)msg.getData());
            Solon.app().listener().onMessage(session, message.isString(true));
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    protected void onClose(WebSocketChannel channel, StreamSourceFrameChannel frameChannel) throws IOException {
        Solon.app().listener().onClose(_SocketServerSession.get(channel));
        _SocketServerSession.remove(channel);
    }

    protected void onError(WebSocketChannel channel, Throwable error) {
        Solon.app().listener().onError(_SocketServerSession.get(channel), error);
    }
}

