/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow;

import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.boot.undertow.PluginUndertow;
import org.noear.solon.boot.undertow.PluginUndertowJsp;
import org.noear.solon.boot.undertow.XServerProp;
import org.noear.solon.core.Aop;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.util.PrintUtil;

public final class XPluginImp
implements Plugin {
    private static Signal _signal;
    private Plugin _server = null;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "undertow 2.1/" + Solon.cfg().version();
    }

    public void start(SolonApp app) {
        if (!app.enableHttp()) {
            return;
        }
        Aop.context().beanBuilderAdd(WebFilter.class, (clz, bw, ano) -> {});
        Aop.context().beanBuilderAdd(WebServlet.class, (clz, bw, ano) -> {});
        Aop.context().beanBuilderAdd(WebListener.class, (clz, bw, ano) -> {});
        XServerProp.init();
        Aop.beanOnloaded(() -> this.start0(app));
    }

    private void start0(SolonApp app) {
        String _name = app.cfg().get("server.http.name");
        int _port = app.cfg().getInt("server.http.port", 0);
        if (_port < 1) {
            _port = app.port();
        }
        long time_start = System.currentTimeMillis();
        PrintUtil.info((Object)"Server:main: Undertow 2.1.09(undertow)");
        Class jspClz = Utils.loadClass((String)"io.undertow.jsp.JspServletBuilder");
        this._server = jspClz == null ? new PluginUndertow(_port) : new PluginUndertowJsp(_port);
        this._server.start(app);
        _signal = new SignalSim(_name, _port, "http", SignalType.HTTP);
        app.signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        String connectorInfo = "solon.connector:main: undertow: Started ServerConnector@{HTTP/1.1,[http/1.1]";
        if (app.enableWebSocket()) {
            System.out.println(connectorInfo + "[WebSocket]}{0.0.0.0:" + _port + "}");
        }
        System.out.println(connectorInfo + "}{http://localhost:" + _port + "}");
        PrintUtil.info((Object)("Server:main: undertow: Started @" + (time_end - time_start) + "ms"));
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
            PrintUtil.info((Object)("Server:main: undertow: Has Stopped " + XPluginImp.solon_boot_ver()));
        }
    }
}

