/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow.websocket;

import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.noear.solon.boot.undertow.websocket._SocketSession;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.extend.socketd.ListenerProxy;
import org.noear.solon.extend.socketd.MessageWrapper;

public class UtWsChannelListener
extends AbstractReceiveListener {
    public void onOpen(WebSocketChannel channel) {
        ListenerProxy.getGlobal().onOpen(_SocketSession.get(channel));
    }

    protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage msg) throws IOException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (ByteBuffer buf : (ByteBuffer[])msg.getData().getResource()) {
                out.write(buf.array());
            }
            Session session = _SocketSession.get(channel);
            Message message = MessageWrapper.wrap((String)channel.getUrl(), null, (byte[])out.toByteArray());
            ListenerProxy.getGlobal().onMessage(session, message, false);
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
    }

    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage msg) throws IOException {
        try {
            Session session = _SocketSession.get(channel);
            Message message = MessageWrapper.wrap((String)channel.getUrl(), null, (byte[])msg.getData().getBytes("UTF-8"));
            ListenerProxy.getGlobal().onMessage(session, message, true);
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
    }

    protected void onClose(WebSocketChannel channel, StreamSourceFrameChannel frameChannel) throws IOException {
        ListenerProxy.getGlobal().onClose(_SocketSession.get(channel));
        _SocketSession.remove(channel);
    }

    protected void onError(WebSocketChannel channel, Throwable error) {
        ListenerProxy.getGlobal().onError(_SocketSession.get(channel), error);
    }
}

