/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow.websocket;

import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.StreamSourceFrameChannel;
import io.undertow.websockets.core.WebSocketChannel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.noear.solon.boot.undertow.websocket._SocketSession;
import org.noear.solon.core.XEventBus;
import org.noear.solon.core.XListener;
import org.noear.solon.core.XMessage;
import org.noear.solon.core.XMethod;
import org.noear.solon.core.XSession;
import org.noear.solon.extend.xsocket.XListenerProxy;
import org.noear.solon.extend.xsocket.XSocketContextHandler;

public class UtWsChannelListener
extends AbstractReceiveListener {
    private XSocketContextHandler handler = new XSocketContextHandler(XMethod.WEBSOCKET);
    private XListener listener = XListenerProxy.getGlobal();

    public void onOpen(WebSocketChannel channel) {
        this.listener.onOpen(_SocketSession.get(channel));
    }

    protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage msg) throws IOException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            for (ByteBuffer buf : (ByteBuffer[])msg.getData().getResource()) {
                out.write(buf.array());
            }
            XSession session = _SocketSession.get(channel);
            XMessage message = XMessage.wrap((String)channel.getUrl(), (byte[])out.toByteArray());
            this.listener.onMessage(session, message);
            if (!message.getHandled()) {
                this.handler.handle(session, message, false);
            }
        }
        catch (Throwable ex) {
            XEventBus.push((Object)ex);
        }
    }

    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage msg) throws IOException {
        try {
            XSession session = _SocketSession.get(channel);
            XMessage message = XMessage.wrap((String)channel.getUrl(), (byte[])msg.getData().getBytes("UTF-8"));
            this.listener.onMessage(session, message);
            if (!message.getHandled()) {
                this.handler.handle(session, message, true);
            }
        }
        catch (Throwable ex) {
            XEventBus.push((Object)ex);
        }
    }

    protected void onClose(WebSocketChannel channel, StreamSourceFrameChannel frameChannel) throws IOException {
        this.listener.onClose(_SocketSession.get(channel));
        _SocketSession.remove(channel);
    }

    protected void onError(WebSocketChannel channel, Throwable error) {
        this.listener.onError(_SocketSession.get(channel), error);
    }
}

