/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow;

import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.jsp.HackInstanceManager;
import io.undertow.jsp.JspServletBuilder;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.servlet.api.ClassIntrospecter;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.util.DefaultClassIntrospector;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import org.apache.tomcat.InstanceManager;
import org.noear.solon.XApp;
import org.noear.solon.XProperties;
import org.noear.solon.boot.undertow.UnderServlet;
import org.noear.solon.boot.undertow.XPluginImp;
import org.noear.solon.boot.undertow.ext.UnderTowConfig;
import org.noear.solon.core.XPlugin;

public class XPluginUndertowJsp
implements XPlugin,
Closeable {
    private static Undertow.Builder serverBuilder = null;
    private static Undertow _server = null;

    public void start(XApp app) {
        UnderTowConfig.app = app;
        UnderTowConfig.debug = true;
        try {
            this.setupJsp(app);
        }
        catch (ServletException e) {
            e.printStackTrace();
        }
        _server.start();
    }

    public void setupJsp(XApp app) throws ServletException {
        String KEY = "io.message";
        ServletContainer container = ServletContainer.Factory.newInstance();
        URLClassLoader jspClassLoader = new URLClassLoader(new URL[0], app.getClass().getClassLoader());
        DeploymentInfo builder = new DeploymentInfo().setClassLoader(XPluginUndertowJsp.class.getClassLoader()).setContextPath("/").setClassIntrospecter((ClassIntrospecter)DefaultClassIntrospector.INSTANCE).setDeploymentName("yukaiIsSoBrilliant").setResourceManager((ResourceManager)new ClassPathResourceManager((ClassLoader)jspClassLoader)).setDefaultMultipartConfig(new MultipartConfigElement(System.getProperty("java.io.tmpdir"))).addServlet(JspServletBuilder.createServlet((String)"JSPServlet", (String)"*.jsp")).addServlet(new ServletInfo("ACTServlet", UnderServlet.class).addMapping("/"));
        XProperties props = app.prop();
        int s_timeout = props.getInt("server.session.timeout", 0);
        if (s_timeout > 0) {
            builder.setDefaultSessionTimeout(s_timeout);
        }
        JspServletBuilder.setupDeployment((DeploymentInfo)builder, new HashMap(), new HashMap(), (InstanceManager)new HackInstanceManager());
        DeploymentManager manager = container.addDeployment(builder);
        manager.deploy();
        HttpHandler jsp_handler = manager.start();
        serverBuilder = XPluginUndertowJsp.getInstance().setServerOption(UndertowOptions.ALWAYS_SET_KEEP_ALIVE, (Object)false);
        serverBuilder.addHttpListener(app.port(), "0.0.0.0");
        serverBuilder.setHandler(jsp_handler);
        _server = serverBuilder.build();
        System.setProperty("io.message", "Hello JSP!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Undertow.Builder getInstance() {
        Class<XPluginImp> clazz = XPluginImp.class;
        synchronized (XPluginImp.class) {
            if (serverBuilder != null) return serverBuilder;
            Class<XPlugin> clazz2 = XPlugin.class;
            synchronized (XPlugin.class) {
                serverBuilder = Undertow.builder();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return serverBuilder;
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (_server != null) {
            _server.stop();
            _server = null;
        }
    }
}

