/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.undertow;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.noear.solon.XApp;
import org.noear.solon.boot.undertow.XPluginImp;
import org.noear.solon.boot.undertow.context.UtHttpServletContext;
import org.noear.solon.core.XContext;

public class UtHttpExchangeHandler
implements HttpHandler {
    protected XApp xapp;
    protected boolean debug;

    public UtHttpExchangeHandler(XApp xapp) {
        this.xapp = xapp;
        this.debug = xapp.prop().argx().getInt("debug") == 1;
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.isInIoThread()) {
            exchange.dispatch((HttpHandler)this);
            return;
        }
        ServletRequestContext servletRequestContext = (ServletRequestContext)exchange.getAttachment(ServletRequestContext.ATTACHMENT_KEY);
        HttpServletRequest request = (HttpServletRequest)servletRequestContext.getServletRequest();
        HttpServletResponse response = (HttpServletResponse)servletRequestContext.getServletResponse();
        UtHttpServletContext context = new UtHttpServletContext(request, response, exchange);
        context.contentType("text/plain;charset=UTF-8");
        context.headerSet("solon.boot", XPluginImp.solon_boot_ver());
        try {
            if (exchange.getRequestURI() != null && !exchange.getRequestURI().endsWith(".jsp")) {
                this.xapp.handle((XContext)context);
            }
            if (context.getHandled() && context.status() != 404) {
                exchange.endExchange();
            } else {
                exchange.setStatusCode(404);
                exchange.endExchange();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            ex.printStackTrace(response.getWriter());
            exchange.setStatusCode(500);
            exchange.endExchange();
        }
    }
}

