/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp.websocket;

import java.net.URI;
import java.nio.ByteBuffer;
import org.noear.solon.boot.smarthttp.websocket.WebSocketImpl;
import org.noear.solon.core.util.RunUtil;
import org.noear.solon.net.websocket.SubProtocolCapable;
import org.noear.solon.net.websocket.WebSocket;
import org.noear.solon.net.websocket.WebSocketRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartboot.http.common.codec.websocket.CloseReason;
import org.smartboot.http.server.WebSocketRequest;
import org.smartboot.http.server.WebSocketResponse;
import org.smartboot.http.server.handler.WebSocketDefaultHandler;
import org.smartboot.http.server.impl.Request;
import org.smartboot.http.server.impl.WebSocketRequestImpl;
import org.smartboot.http.server.impl.WebSocketResponseImpl;
import org.smartboot.socket.util.AttachKey;
import org.smartboot.socket.util.Attachment;

public class SmWebSocketHandleImpl
extends WebSocketDefaultHandler {
    static final Logger log = LoggerFactory.getLogger(SmWebSocketHandleImpl.class);
    static final AttachKey<WebSocketImpl> SESSION_KEY = AttachKey.valueOf((String)"SESSION");
    private final WebSocketRouter webSocketRouter = WebSocketRouter.getInstance();

    public void willHeaderComplete(WebSocketRequestImpl request, WebSocketResponseImpl response) {
        super.willHeaderComplete(request, response);
        String path = URI.create(request.getRequestURL()).getPath();
        SubProtocolCapable subProtocolCapable = this.webSocketRouter.getSubProtocol(path);
        if (subProtocolCapable != null) {
            response.setHeader("Sec-WebSocket-Protocol", subProtocolCapable.getSubProtocols());
        }
    }

    public void onHandShake(WebSocketRequest request, WebSocketResponse response) {
        WebSocketRequestImpl request1 = (WebSocketRequestImpl)request;
        WebSocketImpl webSocket = new WebSocketImpl((WebSocketRequest)request1);
        request1.getHeaderNames().forEach(name -> webSocket.param((String)name, request1.getHeader(name)));
        if (request1.getAttachment() == null) {
            request1.setAttachment(new Attachment());
        }
        request1.getAttachment().put(SESSION_KEY, (Object)webSocket);
        this.webSocketRouter.getListener().onOpen((WebSocket)webSocket);
    }

    public void onClose(Request request) {
        WebSocketRequestImpl request2 = request.newWebsocketRequest();
        this.onCloseDo((WebSocketRequest)request2);
    }

    public void onClose(WebSocketRequest request, WebSocketResponse response, CloseReason closeReason) {
        this.onCloseDo(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCloseDo(WebSocketRequest request) {
        WebSocketRequestImpl request1 = (WebSocketRequestImpl)request;
        try {
            WebSocketImpl webSocket = (WebSocketImpl)((Object)request1.getAttachment().get(SESSION_KEY));
            if (webSocket.isClosed()) {
                return;
            }
            RunUtil.runAndTry(webSocket::close);
            this.webSocketRouter.getListener().onClose((WebSocket)webSocket);
        }
        finally {
            request1.getAttachment().remove(SESSION_KEY);
        }
    }

    public void handlePing(WebSocketRequest request, WebSocketResponse response) {
        super.handlePing(request, response);
        WebSocketRequestImpl request1 = (WebSocketRequestImpl)request;
        WebSocketImpl webSocket = (WebSocketImpl)((Object)request1.getAttachment().get(SESSION_KEY));
        if (webSocket != null) {
            webSocket.onReceive();
        }
        this.webSocketRouter.getListener().onPing((WebSocket)webSocket);
    }

    public void handlePong(WebSocketRequest request, WebSocketResponse response) {
        super.handlePong(request, response);
        WebSocketRequestImpl request1 = (WebSocketRequestImpl)request;
        WebSocketImpl webSocket = (WebSocketImpl)((Object)request1.getAttachment().get(SESSION_KEY));
        if (webSocket != null) {
            webSocket.onReceive();
        }
        this.webSocketRouter.getListener().onPong((WebSocket)webSocket);
    }

    public void handleTextMessage(WebSocketRequest request, WebSocketResponse response, String data) {
        try {
            WebSocketRequestImpl request1 = (WebSocketRequestImpl)request;
            WebSocketImpl webSocket = (WebSocketImpl)((Object)request1.getAttachment().get(SESSION_KEY));
            webSocket.onReceive();
            this.webSocketRouter.getListener().onMessage((WebSocket)webSocket, data);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    public void handleBinaryMessage(WebSocketRequest request, WebSocketResponse response, byte[] data) {
        try {
            WebSocketRequestImpl request1 = (WebSocketRequestImpl)request;
            WebSocketImpl webSocket = (WebSocketImpl)((Object)request1.getAttachment().get(SESSION_KEY));
            webSocket.onReceive();
            this.webSocketRouter.getListener().onMessage((WebSocket)webSocket, ByteBuffer.wrap(data));
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    public void onError(WebSocketRequest request, Throwable error) {
        try {
            WebSocketRequestImpl request1 = (WebSocketRequestImpl)request;
            WebSocket webSocket = (WebSocket)request1.getAttachment().get(SESSION_KEY);
            this.webSocketRouter.getListener().onError(webSocket, error);
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }
}

