/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HeaderValueEnum;
import org.smartboot.http.common.enums.HttpMethodEnum;
import org.smartboot.http.common.enums.HttpProtocolEnum;
import org.smartboot.http.server.Http2ServerHandler;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpResponse;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.HttpServerHandler;
import org.smartboot.http.server.WebSocketHandler;
import org.smartboot.http.server.impl.HttpMessageProcessor;
import org.smartboot.http.server.impl.HttpRequestProtocol;
import org.smartboot.socket.MessageProcessor;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.buffer.BufferPagePool;
import org.smartboot.socket.transport.AioQuickServer;

public class HttpBootstrap {
    private static final String BANNER = "                               _       _      _    _          \n                              ( )_    ( )    ( )_ ( )_        \n  ___   ___ ___     _ _  _ __ | ,_)   | |__  | ,_)| ,_) _ _   \n/',__)/' _ ` _ `\\ /'_` )( '__)| |     |  _ `\\| |  | |  ( '_`\\ \n\\__, \\| ( ) ( ) |( (_| || |   | |_    | | | || |_ | |_ | (_) )\n(____/(_) (_) (_)`\\__,_)(_)   `\\__)   (_) (_)`\\__)`\\__)| ,__/'\n                                                       | |    \n                                                       (_)   ";
    private static final String VERSION = "1.1.22";
    private final HttpMessageProcessor processor;
    private final HttpServerConfiguration configuration = new HttpServerConfiguration();
    private AioQuickServer server;
    private int port = 8080;

    public HttpBootstrap() {
        this(new HttpMessageProcessor());
    }

    public HttpBootstrap(HttpMessageProcessor processor) {
        this.processor = processor;
        this.processor.setConfiguration(this.configuration);
    }

    public HttpBootstrap setPort(int port) {
        this.port = port;
        return this;
    }

    public HttpBootstrap httpHandler(HttpServerHandler httpHandler) {
        this.processor.httpServerHandler(httpHandler);
        return this;
    }

    public HttpBootstrap webSocketHandler(WebSocketHandler webSocketHandler) {
        this.processor.setWebSocketHandler(webSocketHandler);
        return this;
    }

    public HttpServerConfiguration configuration() {
        return this.configuration;
    }

    public void start() {
        this.initByteCache();
        BufferPagePool readBufferPool = new BufferPagePool(this.configuration.getReadPageSize(), 1, false);
        this.configuration.getPlugins().forEach(arg_0 -> ((HttpMessageProcessor)this.processor).addPlugin(arg_0));
        this.server = new AioQuickServer(this.configuration.getHost(), this.port, (Protocol)new HttpRequestProtocol(this.configuration), (MessageProcessor)this.processor);
        this.server.setThreadNum(this.configuration.getThreadNum()).setBannerEnabled(false).setBufferFactory(() -> new BufferPagePool(this.configuration.getWritePageSize(), this.configuration.getWritePageNum(), true)).setReadBufferFactory(bufferPage -> readBufferPool.allocateBufferPage().allocate(this.configuration.getReadBufferSize())).setWriteBuffer(this.configuration.getWriteBufferSize(), 16);
        try {
            if (this.configuration.isBannerEnabled()) {
                System.out.println("                               _       _      _    _          \n                              ( )_    ( )    ( )_ ( )_        \n  ___   ___ ___     _ _  _ __ | ,_)   | |__  | ,_)| ,_) _ _   \n/',__)/' _ ` _ `\\ /'_` )( '__)| |     |  _ `\\| |  | |  ( '_`\\ \n\\__, \\| ( ) ( ) |( (_| || |   | |_    | | | || |_ | |_ | (_) )\n(____/(_) (_) (_)`\\__,_)(_)   `\\__)   (_) (_)`\\__)`\\__)| ,__/'\n                                                       | |    \n                                                       (_)   \r\n :: smart-http :: (1.1.22)");
            }
            if (this.configuration.group() == null) {
                this.server.start();
            } else {
                this.server.start(this.configuration.group());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("server start error.", e);
        }
    }

    private void updateHeaderNameByteTree() {
        this.configuration.getHeaderNameByteTree().addNode(HeaderNameEnum.UPGRADE.getName(), upgrade -> {
            if (HeaderValueEnum.WEBSOCKET.getName().equals(upgrade)) {
                return this.configuration.getWebSocketHandler();
            }
            if (HeaderValueEnum.H2C.getName().equals(upgrade) || HeaderValueEnum.H2.getName().equals(upgrade)) {
                return new Http2ServerHandler(){

                    @Override
                    public void handle(HttpRequest request, HttpResponse response) throws IOException {
                        HttpBootstrap.this.configuration.getHttpServerHandler().handle(request, response);
                    }

                    @Override
                    public void handle(HttpRequest request, HttpResponse response, CompletableFuture<Object> completableFuture) throws IOException {
                        HttpBootstrap.this.configuration.getHttpServerHandler().handle(request, response, completableFuture);
                    }
                };
            }
            return null;
        });
    }

    private void initByteCache() {
        for (HttpMethodEnum httpMethodEnum : HttpMethodEnum.values()) {
            this.configuration.getByteCache().addNode(httpMethodEnum.getMethod());
        }
        for (HttpMethodEnum httpMethodEnum : HttpProtocolEnum.values()) {
            this.configuration.getByteCache().addNode(httpMethodEnum.getProtocol());
        }
        for (HttpMethodEnum httpMethodEnum : HeaderNameEnum.values()) {
            this.configuration.getHeaderNameByteTree().addNode(httpMethodEnum.getName());
        }
        for (HttpMethodEnum httpMethodEnum : HeaderValueEnum.values()) {
            this.configuration.getByteCache().addNode(httpMethodEnum.getName());
        }
        this.updateHeaderNameByteTree();
    }

    public void shutdown() {
        if (this.server != null) {
            this.server.shutdown();
            this.server = null;
        }
    }
}

