/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.smartboot.http.common.enums.HeaderNameEnum;
import org.smartboot.http.common.enums.HeaderValueEnum;
import org.smartboot.http.common.enums.HttpMethodEnum;
import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.exception.HttpException;
import org.smartboot.http.common.utils.FixedLengthFrameDecoder;
import org.smartboot.http.common.utils.SmartDecoder;
import org.smartboot.http.common.utils.StringUtils;
import org.smartboot.http.server.HttpRequest;
import org.smartboot.http.server.HttpResponse;
import org.smartboot.http.server.ServerHandler;
import org.smartboot.http.server.impl.AbstractOutputStream;
import org.smartboot.http.server.impl.Request;
import org.smartboot.http.server.impl.WebSocketResponseImpl;

public abstract class Http2ServerHandler
implements ServerHandler<HttpRequest, HttpResponse> {
    private final Map<Request, SmartDecoder> bodyDecoderMap = new ConcurrentHashMap<Request, SmartDecoder>();

    public void onHeaderComplete(Request request) throws IOException {
        String htt2Settings = request.getHeader(HeaderNameEnum.HTTP2_SETTINGS.getName());
        WebSocketResponseImpl response = request.newWebsocketRequest().getResponse();
        response.setHttpStatus(HttpStatus.SWITCHING_PROTOCOLS);
        response.setHeader(HeaderNameEnum.UPGRADE.getName(), HeaderValueEnum.H2C.getName());
        response.setHeader(HeaderNameEnum.CONNECTION.getName(), HeaderValueEnum.UPGRADE.getName());
        AbstractOutputStream outputStream = response.getOutputStream();
        ((OutputStream)((Object)outputStream)).flush();
    }

    public boolean onBodyStream(ByteBuffer buffer, Request request) {
        if (HttpMethodEnum.GET.getMethod().equals(request.getMethod())) {
            return true;
        }
        if (HttpMethodEnum.POST.getMethod().equals(request.getMethod()) && StringUtils.startsWith((CharSequence)request.getContentType(), (CharSequence)HeaderValueEnum.X_WWW_FORM_URLENCODED.getName())) {
            int postLength = request.getContentLength();
            if (postLength > 0x200000) {
                throw new HttpException(HttpStatus.PAYLOAD_TOO_LARGE);
            }
            if (postLength < 0) {
                throw new HttpException(HttpStatus.LENGTH_REQUIRED);
            }
            SmartDecoder smartDecoder = this.bodyDecoderMap.computeIfAbsent(request, req -> new FixedLengthFrameDecoder(req.getContentLength()));
            if (smartDecoder.decode(buffer)) {
                this.bodyDecoderMap.remove(request);
                request.setFormUrlencoded(new String(smartDecoder.getBuffer().array()));
                return true;
            }
            return false;
        }
        return true;
    }

    public void onClose(Request request) {
        this.bodyDecoderMap.remove(request);
    }
}

