/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.smarthttp.websocket;

import java.nio.ByteBuffer;
import org.noear.solon.Solon;
import org.noear.solon.boot.smarthttp.websocket._SocketServerSession;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.extend.socketd.ListenerProxy;
import org.noear.solon.extend.socketd.MessageUtils;
import org.smartboot.http.WebSocketRequest;
import org.smartboot.http.WebSocketResponse;
import org.smartboot.http.server.handle.WebSocketDefaultHandle;

public class WebSocketHandleImp
extends WebSocketDefaultHandle {
    public void onHandShark(WebSocketRequest request, WebSocketResponse response) {
        ListenerProxy.getGlobal().onOpen((Session)_SocketServerSession.get(request, response));
    }

    public void onClose(WebSocketRequest request, WebSocketResponse response) {
        _SocketServerSession session = _SocketServerSession.get(request, response);
        session.onClose();
        ListenerProxy.getGlobal().onClose((Session)session);
        _SocketServerSession.remove(request);
    }

    public void handleTextMessage(WebSocketRequest request, WebSocketResponse response, String data) {
        try {
            _SocketServerSession session = _SocketServerSession.get(request, response);
            Message message = MessageUtils.wrap((String)request.getRequestURI(), null, (byte[])data.getBytes("UTF-8"));
            ListenerProxy.getGlobal().onMessage((Session)session, message, true);
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
    }

    public void handleBinaryMessage(WebSocketRequest request, WebSocketResponse response, byte[] data) {
        try {
            _SocketServerSession session = _SocketServerSession.get(request, response);
            Message message = null;
            message = Solon.global().enableWebSocketD() ? MessageUtils.decode((ByteBuffer)ByteBuffer.wrap(data)) : MessageUtils.wrap((String)request.getRequestURI(), null, (byte[])data);
            ListenerProxy.getGlobal().onMessage((Session)session, message, false);
        }
        catch (Throwable ex) {
            EventBus.push((Object)ex);
        }
    }

    public void onError(Throwable error) {
    }
}

