/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.smartboot.http.WebSocketRequest;
import org.smartboot.http.enums.WebsocketStatus;
import org.smartboot.http.server.AbstractRequest;
import org.smartboot.http.server.Request;
import org.smartboot.http.server.WebSocketResponseImpl;

public class WebSocketRequestImpl
extends AbstractRequest
implements WebSocketRequest {
    public static final byte OPCODE_CONT = 0;
    public static final byte OPCODE_TEXT = 1;
    public static final byte OPCODE_BINARY = 2;
    public static final byte OPCODE_CLOSE = 8;
    public static final byte OPCODE_PING = 9;
    public static final byte OPCODE_PONG = 10;
    private WebsocketStatus websocketStatus;
    private boolean frameFinalFlag;
    private boolean frameMasked;
    private int frameRsv;
    private int frameOpcode;
    private ByteArrayOutputStream payload = new ByteArrayOutputStream();
    private WebSocketResponseImpl response;

    public WebSocketRequestImpl(Request baseHttpRequest) {
        this.init(baseHttpRequest);
        this.websocketStatus = WebsocketStatus.HandShake;
        this.response = new WebSocketResponseImpl(this, (OutputStream)baseHttpRequest.getAioSession().writeBuffer());
    }

    public final WebSocketResponseImpl getResponse() {
        return this.response;
    }

    @Override
    public WebsocketStatus getWebsocketStatus() {
        return this.websocketStatus;
    }

    public void setWebsocketStatus(WebsocketStatus websocketStatus) {
        this.websocketStatus = websocketStatus;
    }

    @Override
    public InputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        this.payload.reset();
    }

    public boolean isFrameFinalFlag() {
        return this.frameFinalFlag;
    }

    public void setFrameFinalFlag(boolean frameFinalFlag) {
        this.frameFinalFlag = frameFinalFlag;
    }

    public boolean isFrameMasked() {
        return this.frameMasked;
    }

    public void setFrameMasked(boolean frameMasked) {
        this.frameMasked = frameMasked;
    }

    public int getFrameRsv() {
        return this.frameRsv;
    }

    public void setFrameRsv(int frameRsv) {
        this.frameRsv = frameRsv;
    }

    @Override
    public int getFrameOpcode() {
        return this.frameOpcode;
    }

    public void setFrameOpcode(int frameOpcode) {
        this.frameOpcode = frameOpcode;
    }

    @Override
    public byte[] getPayload() {
        return this.payload.toByteArray();
    }

    public void setPayload(byte[] payload) {
        try {
            this.payload.write(payload);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

