/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty.websocket;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.boot.jetty.websocket._CallbackImpl;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.message.Message;
import org.noear.solon.core.message.Session;
import org.noear.solon.socketd.ProtocolManager;
import org.noear.solon.socketd.SessionBase;

public class _SocketServerSession
extends SessionBase {
    public static final Map<org.eclipse.jetty.websocket.api.Session, Session> sessions = new HashMap<org.eclipse.jetty.websocket.api.Session, Session>();
    private final org.eclipse.jetty.websocket.api.Session real;
    private final String _sessionId = Utils.guid();
    private URI _uri;
    private String _path;
    private boolean _open = true;
    private Object attachment;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session get(org.eclipse.jetty.websocket.api.Session real) {
        Object tmp = sessions.get(real);
        if (tmp == null) {
            org.eclipse.jetty.websocket.api.Session session = real;
            synchronized (session) {
                tmp = sessions.get(real);
                if (tmp == null) {
                    tmp = new _SocketServerSession(real);
                    sessions.put(real, (Session)tmp);
                }
            }
        }
        return tmp;
    }

    public static void remove(org.eclipse.jetty.websocket.api.Session real) {
        sessions.remove(real);
    }

    public _SocketServerSession(org.eclipse.jetty.websocket.api.Session real) {
        this.real = real;
    }

    public Object real() {
        return this.real;
    }

    public String sessionId() {
        return this._sessionId;
    }

    public MethodType method() {
        return MethodType.WEBSOCKET;
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = this.real.getUpgradeRequest().getRequestURI();
        }
        return this._uri;
    }

    public String path() {
        if (this._path == null) {
            this._path = this.uri().getPath();
        }
        return this._path;
    }

    public void sendAsync(String message) {
        if (Solon.app().enableWebSocketD()) {
            ByteBuffer buf = ProtocolManager.encode((Message)Message.wrap((String)message));
            this.real.getRemote().sendBytes(buf, _CallbackImpl.instance);
        } else {
            this.real.getRemote().sendString(message, _CallbackImpl.instance);
        }
    }

    public void sendAsync(Message message) {
        super.send(message);
        if (Solon.app().enableWebSocketD()) {
            ByteBuffer buf = ProtocolManager.encode((Message)message);
            this.real.getRemote().sendBytes(buf, _CallbackImpl.instance);
        } else if (message.isString()) {
            this.real.getRemote().sendString(message.bodyAsString(), _CallbackImpl.instance);
        } else {
            ByteBuffer buf = ByteBuffer.wrap(message.body());
            this.real.getRemote().sendBytes(buf, _CallbackImpl.instance);
        }
    }

    public void send(String message) {
        try {
            if (Solon.app().enableWebSocketD()) {
                ByteBuffer buf = ProtocolManager.encode((Message)Message.wrap((String)message));
                this.real.getRemote().sendBytes(buf);
            } else {
                this.real.getRemote().sendString(message);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void send(Message message) {
        super.send(message);
        try {
            if (Solon.app().enableWebSocketD()) {
                ByteBuffer buf = ProtocolManager.encode((Message)message);
                this.real.getRemote().sendBytes(buf);
            } else if (message.isString()) {
                this.real.getRemote().sendString(message.bodyAsString());
            } else {
                ByteBuffer buf = ByteBuffer.wrap(message.body());
                this.real.getRemote().sendBytes(buf);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws IOException {
        super.close();
        if (this.real == null) {
            return;
        }
        this._open = false;
        this.real.close();
        sessions.remove(this.real);
    }

    public boolean isValid() {
        if (this.real == null) {
            return false;
        }
        return this._open && this.real.isOpen();
    }

    public boolean isSecure() {
        return this.real.isSecure();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.real.getRemoteAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return this.real.getLocalAddress();
    }

    public void setAttachment(Object obj) {
        this.attachment = obj;
    }

    public <T> T getAttachment() {
        return (T)this.attachment;
    }

    public Collection<Session> getOpenSessions() {
        return Collections.unmodifiableCollection(sessions.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        _SocketServerSession that = (_SocketServerSession)((Object)o);
        return Objects.equals(this.real, that.real);
    }

    public int hashCode() {
        return Objects.hash(this.real);
    }
}

