/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import java.io.IOException;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.jetty.HandlerHub;
import org.noear.solon.boot.jetty.PluginJettyBase;
import org.noear.solon.boot.jetty.http.JtHttpContextHandler;
import org.noear.solon.boot.jetty.websocket._SessionManagerImpl;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.event.EventBus;
import org.noear.solon.socketd.SessionManager;

class PluginJetty
extends PluginJettyBase
implements Plugin {
    protected Server _server = null;
    private int port;

    public PluginJetty(int port) {
        this.port = port;
    }

    public void start(SolonApp app) {
        try {
            this.setup(app);
            this._server.start();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
        }
    }

    protected void setup(SolonApp app) throws IOException {
        Class wsClz = Utils.loadClass((String)"org.eclipse.jetty.websocket.server.WebSocketHandler");
        this._server = new Server();
        HttpConfiguration config = new HttpConfiguration();
        if (ServerProps.request_maxHeaderSize != 0) {
            config.setRequestHeaderSize(ServerProps.request_maxHeaderSize);
        }
        ServerConnector connector = new ServerConnector(this._server, new ConnectionFactory[]{new HttpConnectionFactory(config)});
        connector.setPort(this.port);
        this._server.addConnector((Connector)connector);
        if (Solon.global().enableSessionState()) {
            this._server.setSessionIdManager((SessionIdManager)new DefaultSessionIdManager(this._server));
        }
        if (app.enableWebSocket() && wsClz != null) {
            this._server.setHandler((Handler)new HandlerHub(this.buildHandler()));
            SessionManager.register((SessionManager)new _SessionManagerImpl());
        } else {
            this._server.setHandler(this.buildHandler());
        }
        EventBus.push((Object)this._server);
    }

    protected Handler buildHandler() throws IOException {
        if (Utils.loadClass((String)"org.eclipse.jetty.servlet.ServletContextHandler") == null) {
            JtHttpContextHandler _handler = new JtHttpContextHandler();
            if (Solon.global().enableSessionState()) {
                SessionHandler s_handler = new SessionHandler();
                if (ServerProps.session_timeout > 0) {
                    s_handler.setMaxInactiveInterval(ServerProps.session_timeout);
                }
                s_handler.setHandler((Handler)_handler);
                return s_handler;
            }
            return _handler;
        }
        return this.getServletHandler();
    }
}

