/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.boot.ServerLifecycle;
import org.noear.solon.boot.ServerProps;
import org.noear.solon.boot.jetty.JettyServer;
import org.noear.solon.boot.jetty.JettyServerAddJsp;
import org.noear.solon.boot.jetty.http.FormContentFilter;
import org.noear.solon.boot.prop.HttpSignalProps;
import org.noear.solon.core.AopContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.util.PrintUtil;

public final class XPluginImp
implements Plugin {
    private static Signal _signal;
    private ServerLifecycle _server = null;

    public static Signal signal() {
        return _signal;
    }

    public static String solon_boot_ver() {
        return "jetty 9.4/" + Solon.cfg().version();
    }

    public void start(AopContext context) {
        if (!Solon.app().enableHttp()) {
            return;
        }
        if (ServerProps.request_maxBodySize != 0) {
            System.setProperty("org.eclipse.jetty.server.Request.maxFormContentSize", String.valueOf(ServerProps.request_maxBodySize));
        }
        context.beanBuilderAdd(WebFilter.class, (clz, bw, ano) -> {});
        context.beanBuilderAdd(WebServlet.class, (clz, bw, ano) -> {});
        context.beanBuilderAdd(WebListener.class, (clz, bw, ano) -> {});
        context.beanOnloaded(ctx -> {
            try {
                this.start0(Solon.app());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void start0(SolonApp app) throws Throwable {
        ServerProps.init();
        Class jspClz = Utils.loadClass((String)"org.eclipse.jetty.jsp.JettyJspServlet");
        HttpSignalProps props = new HttpSignalProps();
        String _host = props.getHost();
        int _port = props.getPort();
        String _name = props.getName();
        this._server = jspClz == null ? new JettyServer() : new JettyServerAddJsp();
        long time_start = System.currentTimeMillis();
        PrintUtil.info((Object)"Server:main: Jetty 9.4(jetty)");
        this._server.start(_host, _port);
        _signal = new SignalSim(_name, _port, "http", SignalType.HTTP);
        app.signalAdd(_signal);
        long time_end = System.currentTimeMillis();
        String connectorInfo = "solon.connector:main: jetty: Started ServerConnector@{HTTP/1.1,[http/1.1]";
        if (app.enableWebSocket()) {
            System.out.println(connectorInfo + "[WebSocket]}{0.0.0.0:" + _port + "}");
        }
        System.out.println(connectorInfo + "}{http://localhost:" + _port + "}");
        PrintUtil.info((Object)("Server:main: jetty: Started @" + (time_end - time_start) + "ms"));
        app.before(-9, (Handler)new FormContentFilter());
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
            PrintUtil.info((Object)("Server:main: jetty: Has Stopped " + XPluginImp.solon_boot_ver()));
        }
    }
}

