/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.WebAppContext;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.boot.jetty.HandlerHub;
import org.noear.solon.boot.jetty.XServerProp;
import org.noear.solon.boot.jetty.http.JtHttpContextHandler;
import org.noear.solon.boot.jetty.http.JtHttpContextServlet;
import org.noear.solon.core.XPlugin;

class XPluginJetty
implements XPlugin {
    protected Server _server = null;

    XPluginJetty() {
    }

    public void start(XApp app) {
        try {
            Class wsClz = XUtil.loadClass((String)"org.eclipse.jetty.websocket.server.WebSocketHandler");
            this._server = new Server(app.port());
            this._server.setSessionIdManager((SessionIdManager)new DefaultSessionIdManager(this._server));
            if (app.enableWebSocket() && wsClz != null) {
                this._server.setHandler((Handler)new HandlerHub(this.getServerHandler()));
            } else {
                this._server.setHandler(this.getServerHandler());
            }
            this._server.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", (Object)XServerProp.request_maxRequestSize);
            app.prop().forEach((k, v) -> {
                String key = k.toString();
                if (key.indexOf(".jetty.") > 0) {
                    this._server.setAttribute(key, v);
                }
            });
            app.prop().onChange((k, v) -> {
                if (k.indexOf(".jetty.") > 0) {
                    this._server.setAttribute(k, v);
                }
            });
            this._server.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
        }
    }

    protected Handler getServerHandler() throws IOException {
        if (XUtil.loadClass((String)"org.eclipse.jetty.webapp.WebAppContext") == null) {
            SessionHandler s_handler = new SessionHandler();
            if (XServerProp.session_timeout > 0) {
                s_handler.setMaxInactiveInterval(XServerProp.session_timeout);
            }
            JtHttpContextHandler _handler = new JtHttpContextHandler();
            s_handler.setHandler((Handler)_handler);
            return s_handler;
        }
        return this.getWebServerHandler();
    }

    private Handler getWebServerHandler() throws IOException {
        WebAppContext handler = new WebAppContext();
        handler.setSessionHandler(new SessionHandler());
        handler.setContextPath("/");
        handler.setDescriptor("/WEB-INF/web.xml");
        handler.addServlet(JtHttpContextServlet.class, "/");
        handler.setBaseResource((Resource)new ResourceCollection(this.getResourceURLs()));
        if (XServerProp.session_timeout > 0) {
            handler.getSessionHandler().setMaxInactiveInterval(XServerProp.session_timeout);
        }
        return handler;
    }

    protected String[] getResourceURLs() throws FileNotFoundException {
        URL rootURL = this.getRootPath();
        if (rootURL == null) {
            throw new FileNotFoundException("Unable to find root");
        }
        String resURL = rootURL.toString();
        boolean isDebug = XApp.cfg().isDebugMode();
        if (isDebug && !resURL.startsWith("jar:")) {
            int endIndex = resURL.indexOf("target");
            String debugResURL = resURL.substring(0, endIndex) + "src/main/resources/";
            return new String[]{debugResURL, resURL};
        }
        return new String[]{resURL};
    }

    protected URL getRootPath() {
        URL root = XUtil.getResource((String)"/");
        if (root != null) {
            return root;
        }
        try {
            String path = XUtil.getResource((String)"").toString();
            if (!path.startsWith("jar:")) {
                return null;
            }
            int endIndex = path.indexOf("!");
            path = path.substring(0, endIndex + 1) + "/";
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

