/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import java.io.IOException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.noear.solon.XApp;
import org.noear.solon.XUtil;
import org.noear.solon.boot.jetty.HandlerHub;
import org.noear.solon.boot.jetty.XServerProp;
import org.noear.solon.boot.jetty.http.JtHttpContextHandler;
import org.noear.solon.core.XPlugin;

class XPluginJetty
implements XPlugin {
    protected Server _server = null;

    XPluginJetty() {
    }

    public void start(XApp app) {
        try {
            Class wsClz = XUtil.loadClass((String)"org.eclipse.jetty.websocket.server.WebSocketHandler");
            this._server = new Server(app.port());
            this._server.setSessionIdManager((SessionIdManager)new DefaultSessionIdManager(this._server));
            if (app.enableWebSocket() && wsClz != null) {
                this._server.setHandler((Handler)new HandlerHub(this.getServerHandler()));
            } else {
                this._server.setHandler(this.getServerHandler());
            }
            this._server.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", (Object)XServerProp.request_maxRequestSize);
            app.prop().forEach((k, v) -> {
                String key = k.toString();
                if (key.indexOf(".jetty.") > 0) {
                    this._server.setAttribute(key, v);
                }
            });
            app.prop().onChange((k, v) -> {
                if (k.indexOf(".jetty.") > 0) {
                    this._server.setAttribute(k, v);
                }
            });
            this._server.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stop() throws Throwable {
        if (this._server != null) {
            this._server.stop();
            this._server = null;
        }
    }

    protected Handler getServerHandler() throws IOException {
        SessionHandler s_handler = new SessionHandler();
        if (XServerProp.session_timeout > 0) {
            s_handler.setMaxInactiveInterval(XServerProp.session_timeout);
        }
        JtHttpContextHandler _handler = new JtHttpContextHandler();
        s_handler.setHandler((Handler)_handler);
        return s_handler;
    }
}

