/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.noear.solon.XUtil;
import org.noear.solon.boot.jetty.MultipartUtil;
import org.noear.solon.core.XContext;
import org.noear.solon.core.XFile;
import org.noear.solon.core.XMap;
import org.noear.solon.core.XSessionState;

public class JtHttpContext
extends XContext {
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    protected Map<String, List<XFile>> _fileMap;
    private String _ip;
    private URI _uri;
    private XMap _paramMap;
    private XMap _cookieMap;
    private XMap _headerMap;

    public JtHttpContext(HttpServletRequest request, HttpServletResponse response) {
        this._request = request;
        this._response = response;
        if (this.sessionState().replaceable()) {
            this.sessionStateInit(new XSessionState(){

                public String sessionId() {
                    return JtHttpContext.this._request.getRequestedSessionId();
                }

                public Object sessionGet(String key) {
                    return JtHttpContext.this._request.getSession().getAttribute(key);
                }

                public void sessionSet(String key, Object val) {
                    JtHttpContext.this._request.getSession().setAttribute(key, val);
                }
            });
        }
        if (this.isMultipart()) {
            try {
                this._fileMap = new HashMap<String, List<XFile>>();
                MultipartUtil.buildParamsAndFiles(this);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    public Object request() {
        return this._request;
    }

    public String ip() {
        if (this._ip == null) {
            this._ip = this.header("X-Forwarded-For");
            if (this._ip == null) {
                this._ip = this._request.getRemoteAddr();
            }
        }
        return this._ip;
    }

    public String method() {
        return this._request.getMethod();
    }

    public String protocol() {
        return this._request.getProtocol();
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public String path() {
        return this.uri().getPath();
    }

    public String url() {
        return this._request.getRequestURL().toString();
    }

    public long contentLength() {
        return this._request.getContentLength();
    }

    public String contentType() {
        return this._request.getContentType();
    }

    public String body() throws IOException {
        InputStream inpStream = this.bodyAsStream();
        StringBuilder content = new StringBuilder();
        byte[] b = new byte[1024];
        int lens = -1;
        while ((lens = inpStream.read(b)) > 0) {
            content.append(new String(b, 0, lens));
        }
        return content.toString();
    }

    public InputStream bodyAsStream() throws IOException {
        return this._request.getInputStream();
    }

    public String[] paramValues(String key) {
        return this._request.getParameterValues(key);
    }

    public String param(String key) {
        return this.param(key, null);
    }

    public String param(String key, String def) {
        String temp = this.paramMap().get((Object)key);
        if (XUtil.isEmpty((String)temp)) {
            return def;
        }
        return temp;
    }

    public XMap paramMap() {
        if (this._paramMap == null) {
            this._paramMap = new XMap();
            Enumeration names = this._request.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                String value = this._request.getParameter(name);
                this._paramMap.put((Object)name, (Object)value);
            }
        }
        return this._paramMap;
    }

    public List<XFile> files(String key) throws Exception {
        if (this.isMultipartFormData()) {
            List<XFile> temp = this._fileMap.get(key);
            if (temp == null) {
                return new ArrayList<XFile>();
            }
            return temp;
        }
        return new ArrayList<XFile>();
    }

    public String cookie(String key) {
        return this.cookie(key, null);
    }

    public String cookie(String key, String def) {
        String temp = this.cookieMap().get((Object)key);
        if (temp == null) {
            return def;
        }
        return temp;
    }

    public XMap cookieMap() {
        if (this._cookieMap == null) {
            this._cookieMap = new XMap();
            Cookie[] _cookies = this._request.getCookies();
            if (_cookies != null) {
                for (Cookie c : _cookies) {
                    this._cookieMap.put((Object)c.getName(), (Object)c.getValue());
                }
            }
        }
        return this._cookieMap;
    }

    public String header(String key) {
        return this._request.getHeader(key);
    }

    public String header(String key, String def) {
        String temp = this._request.getHeader(key);
        if (XUtil.isEmpty((String)temp)) {
            return def;
        }
        return temp;
    }

    public XMap headerMap() {
        if (this._headerMap == null) {
            this._headerMap = new XMap();
            Enumeration headers = this._request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String key = (String)headers.nextElement();
                String value = this._request.getHeader(key);
                this._headerMap.put((Object)key, (Object)value);
            }
        }
        return this._headerMap;
    }

    public Object response() {
        return this._response;
    }

    public void charset(String charset) {
        this._response.setCharacterEncoding(charset);
    }

    public void contentType(String contentType) {
        this._response.setContentType(contentType);
    }

    public OutputStream outputStream() throws IOException {
        return this._response.getOutputStream();
    }

    public void output(String str) {
        try {
            PrintWriter writer = this._response.getWriter();
            writer.write(str);
            writer.flush();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            ServletOutputStream out = this._response.getOutputStream();
            byte[] buff = new byte[100];
            int rc = 0;
            while ((rc = stream.read(buff, 0, 100)) > 0) {
                out.write(buff, 0, rc);
            }
            out.flush();
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void headerSet(String key, String val) {
        this._response.setHeader(key, val);
    }

    public void cookieSet(String key, String val, String domain, String path, int maxAge) {
        Cookie c = new Cookie(key, val);
        c.setPath(path);
        c.setMaxAge(maxAge);
        if (domain != null) {
            c.setDomain(domain);
        }
        this._response.addCookie(c);
    }

    public void redirect(String url) {
        try {
            this._response.sendRedirect(url);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void redirect(String url, int code) {
        this.status(code);
        this._response.setHeader("Location", url);
    }

    public int status() {
        return this._response.getStatus();
    }

    public void status(int status) {
        this._response.setStatus(status);
    }
}

