/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.eclipse.jetty.jsp.JettyJspServlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.noear.solon.XApp;
import org.noear.solon.XProperties;
import org.noear.solon.XUtil;
import org.noear.solon.boot.jetty.JspHttpContextServlet;
import org.noear.solon.boot.jetty.JspStarter;
import org.noear.solon.boot.jetty.XServerProp;
import org.noear.solon.core.XPlugin;

final class XPluginJettyJsp
implements XPlugin,
Closeable {
    private Server _server = null;

    XPluginJettyJsp() {
    }

    public void start(XApp app) {
        XProperties props = app.prop();
        try {
            ServletContextHandler handler = new ServletContextHandler(1);
            handler.setContextPath("/");
            handler.setBaseResource((Resource)new ResourceCollection(this.getResourceURLs()));
            handler.addServlet(JspHttpContextServlet.class, "/");
            if (XServerProp.session_timeout > 0) {
                handler.getSessionHandler().setMaxInactiveInterval(XServerProp.session_timeout);
            }
            this.enableJspSupport(handler);
            this._server = new Server(app.port());
            this._server.setSessionIdManager((SessionIdManager)new DefaultSessionIdManager(this._server));
            this._server.setHandler((Handler)handler);
            this._server.setAttribute("org.eclipse.jetty.server.Request.maxFormContentSize", (Object)XServerProp.request_maxRequestSize);
            if (props != null) {
                props.forEach((k, v) -> {
                    String key = k.toString();
                    if (key.indexOf(".jetty.") > 0) {
                        this._server.setAttribute(key, v);
                    }
                });
                props.onChange((k, v) -> {
                    if (k.indexOf(".jetty.") > 0) {
                        this._server.setAttribute(k, v);
                    }
                });
            }
            this._server.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void enableJspSupport(ServletContextHandler handler) throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File scratchDir = new File(tempDir.toString(), "solon.boot.jetty.jsp");
        if (!scratchDir.exists() && !scratchDir.mkdirs()) {
            throw new IOException("Unable to create scratch directory: " + scratchDir);
        }
        handler.setAttribute("javax.servlet.context.tempdir", (Object)scratchDir);
        URLClassLoader jspClassLoader = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
        handler.setClassLoader((ClassLoader)jspClassLoader);
        handler.addBean((Object)new JspStarter(handler));
        ServletHolder holderJsp = new ServletHolder("jsp", JettyJspServlet.class);
        holderJsp.setInitOrder(0);
        Properties properties = XApp.global().prop().getProp("solon.jetty.jsp");
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> holderJsp.setInitParameter((String)k, (String)v)));
        handler.addServlet(holderJsp, "*.jsp");
    }

    private String[] getResourceURLs() throws FileNotFoundException {
        boolean isDebug;
        URL rootURL = this.getRootPath();
        if (rootURL == null) {
            throw new FileNotFoundException("Unable to find root");
        }
        String resURL = rootURL.toString();
        boolean bl = isDebug = XApp.global().prop().argx().getInt("debug") == 1;
        if (isDebug && !resURL.startsWith("jar:")) {
            int endIndex = resURL.indexOf("target");
            String debugResURL = resURL.substring(0, endIndex) + "src/main/resources/";
            return new String[]{debugResURL, resURL};
        }
        return new String[]{resURL};
    }

    private URL getRootPath() {
        URL root = XUtil.getResource((String)"/");
        if (root != null) {
            return root;
        }
        try {
            String path = XUtil.getResource((String)"").toString();
            if (!path.startsWith("jar:")) {
                return null;
            }
            int endIndex = path.indexOf("!");
            path = path.substring(0, endIndex + 1) + "/";
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this._server != null) {
                this._server.stop();
                this._server = null;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

