/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jetty;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.eclipse.jetty.jsp.JettyJspServlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.noear.solon.XApp;
import org.noear.solon.XProperties;
import org.noear.solon.XUtil;
import org.noear.solon.boot.jetty.JspHttpContextServlet;
import org.noear.solon.boot.jetty.JspStarter;
import org.noear.solon.core.XPlugin;

final class XPluginJettyJsp
implements XPlugin {
    private Server _server = null;

    XPluginJettyJsp() {
    }

    public void start(XApp app) {
        XProperties props = app.prop();
        int s_timeout = props.getInt("server.session.timeout", 0);
        try {
            ServletContextHandler servletContextHandler = new ServletContextHandler(1);
            servletContextHandler.setContextPath("/");
            servletContextHandler.setBaseResource((Resource)new ResourceCollection(this.getResourceURLs()));
            servletContextHandler.addServlet(JspHttpContextServlet.class, "/");
            if (s_timeout > 0) {
                servletContextHandler.getSessionHandler().setMaxInactiveInterval(s_timeout);
            }
            this.enableJspSupport(servletContextHandler);
            this._server = new Server(app.port());
            this._server.setSessionIdManager(new DefaultSessionIdManager(this._server));
            this._server.setHandler((Handler)servletContextHandler);
            if (props != null) {
                props.forEach((k, v) -> {
                    String key = k.toString();
                    if (key.indexOf(".jetty.") > 0) {
                        this._server.setAttribute(key, v);
                    }
                });
            }
            this._server.start();
            app.onStop(this::stop);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stop() {
        try {
            this._server.stop();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void enableJspSupport(ServletContextHandler servletContextHandler) throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        File scratchDir = new File(tempDir.toString(), "solon.boot.jetty.jsp");
        if (!scratchDir.exists() && !scratchDir.mkdirs()) {
            throw new IOException("Unable to create scratch directory: " + scratchDir);
        }
        servletContextHandler.setAttribute("javax.servlet.context.tempdir", (Object)scratchDir);
        URLClassLoader jspClassLoader = new URLClassLoader(new URL[0], this.getClass().getClassLoader());
        servletContextHandler.setClassLoader((ClassLoader)jspClassLoader);
        servletContextHandler.addBean((Object)new JspStarter(servletContextHandler));
        ServletHolder holderJsp = new ServletHolder("jsp", JettyJspServlet.class);
        holderJsp.setInitOrder(0);
        Properties properties = XApp.global().prop().getProp("solon.jetty.jsp");
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> holderJsp.setInitParameter((String)k, (String)v)));
        servletContextHandler.addServlet(holderJsp, "*.jsp");
    }

    private String[] getResourceURLs() throws FileNotFoundException {
        boolean isDebug;
        URL rootURL = this.getRootPath();
        if (rootURL == null) {
            throw new FileNotFoundException("Unable to find root");
        }
        String resURL = rootURL.toString();
        boolean bl = isDebug = XApp.global().prop().argx().getInt("debug") == 1;
        if (isDebug && !resURL.startsWith("jar:")) {
            int endIndex = resURL.indexOf("target");
            String debugResURL = resURL.substring(0, endIndex) + "src/main/resources/";
            return new String[]{debugResURL, resURL};
        }
        return new String[]{resURL};
    }

    private URL getRootPath() {
        URL root = XUtil.getResource((String)"/");
        if (root != null) {
            return root;
        }
        try {
            String path = XUtil.getResource((String)"").toString();
            if (!path.startsWith("jar:")) {
                return null;
            }
            int endIndex = path.indexOf("!");
            path = path.substring(0, endIndex + 1) + "/";
            return new URL(path);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

