/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jdkhttp;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.boot.jdkhttp.JdkHttpContextHandler;
import org.noear.solon.boot.jdkhttp.ParameterFilter;
import org.noear.solon.boot.jdkhttp.XServerProp;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.Signal;
import org.noear.solon.core.SignalSim;
import org.noear.solon.core.SignalType;

public final class XPluginImp
implements Plugin {
    private HttpServer _server = null;

    public static String solon_boot_ver() {
        return "jdk http/" + Solon.cfg().version();
    }

    public void start(SolonApp app) {
        if (!app.enableHttp()) {
            return;
        }
        XServerProp.init();
        String _name = app.cfg().get("server.http.name");
        int _port = app.cfg().getInt("server.http.port", 0);
        if (_port < 1) {
            _port = app.port();
        }
        long time_start = System.currentTimeMillis();
        System.out.println("solon.Server:main: Sun.net.HttpServer(jdkhttp)");
        try {
            this._server = HttpServer.create(new InetSocketAddress(_port), 0);
            HttpContext context = this._server.createContext("/", new JdkHttpContextHandler());
            context.getFilters().add(new ParameterFilter());
            this._server.setExecutor(Executors.newCachedThreadPool());
            this._server.start();
            app.signalAdd((Signal)new SignalSim(_name, _port, "http", SignalType.HTTP));
            long time_end = System.currentTimeMillis();
            System.out.println("solon.Connector:main: jdkhttp: Started ServerConnector@{HTTP/1.1,[http/1.1]}{0.0.0.0:" + _port + "}");
            System.out.println("solon.Server:main: jdkhttp: Started @" + (time_end - time_start) + "ms");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stop() throws Throwable {
        if (this._server == null) {
            return;
        }
        this._server.stop(0);
        this._server = null;
        System.out.println("solon.Server:main: jdkhttp: Has Stopped " + XPluginImp.solon_boot_ver());
    }
}

