/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.boot.jdkhttp;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.solon.Utils;
import org.noear.solon.boot.jdkhttp.MultipartUtil;
import org.noear.solon.core.NvMap;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.UploadedFile;

public class JdkHttpContext
extends Context {
    private HttpExchange _exchange;
    private Map<String, Object> _parameters;
    protected Map<String, List<UploadedFile>> _fileMap;
    private String _ip;
    private String _url;
    private NvMap _paramMap;
    private Map<String, List<String>> _paramsMap;
    private NvMap _cookieMap;
    private NvMap _headerMap;
    private int _status = 200;
    private boolean _allows_write = true;
    private boolean _headers_sent = false;

    public JdkHttpContext(HttpExchange exchange) {
        this._exchange = exchange;
        this._parameters = (Map)this._exchange.getAttribute("parameters");
        if (this.isMultipart()) {
            try {
                this._fileMap = new HashMap<String, List<UploadedFile>>();
                MultipartUtil.buildParamsAndFiles(this);
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public Object request() {
        return this._exchange;
    }

    public String ip() {
        if (this._ip == null) {
            this._ip = this.header("X-Forwarded-For");
            if (this._ip == null) {
                this._ip = this._exchange.getRemoteAddress().getAddress().getHostAddress();
            }
        }
        return this._ip;
    }

    public String method() {
        return this._exchange.getRequestMethod();
    }

    public String protocol() {
        return this._exchange.getProtocol();
    }

    public URI uri() {
        return URI.create(this.url());
    }

    public String path() {
        return this.uri().getPath();
    }

    public String url() {
        if (this._url == null) {
            this._url = this._exchange.getRequestURI().toString();
            if (this._url != null && this._url.startsWith("/")) {
                String host = this.header("Host");
                if (host == null) {
                    host = this.header(":authority");
                    String scheme = this.header(":scheme");
                    if (host == null) {
                        host = "localhost";
                    }
                    this._url = scheme != null ? "https://" + host + this._url : scheme + "://" + host + this._url;
                } else {
                    this._url = "http://" + host + this._url;
                }
            }
        }
        return this._url;
    }

    public long contentLength() {
        try {
            return this.bodyAsStream().available();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return 0L;
        }
    }

    public String contentType() {
        return this.header("Content-Type");
    }

    public InputStream bodyAsStream() throws IOException {
        return this._exchange.getRequestBody();
    }

    public String[] paramValues(String key) {
        List<String> list = this.paramsMap().get(key);
        if (list == null) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public String param(String key) {
        return (String)this.paramMap().get((Object)key);
    }

    public String param(String key, String def) {
        try {
            String temp = (String)this.paramMap().get((Object)key);
            if (Utils.isEmpty((String)temp)) {
                return def;
            }
            return temp;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return def;
        }
    }

    public NvMap paramMap() {
        if (this._paramMap == null) {
            this._paramMap = new NvMap();
            this._parameters.forEach((k, v) -> {
                if (v instanceof List) {
                    this._paramMap.put(k, ((List)v).get(0));
                } else {
                    this._paramMap.put(k, (Object)((String)v));
                }
            });
        }
        return this._paramMap;
    }

    public Map<String, List<String>> paramsMap() {
        if (this._paramsMap == null) {
            this._paramsMap = new LinkedHashMap<String, List<String>>();
            this._parameters.forEach((k, v) -> {
                if (v instanceof List) {
                    this._paramsMap.put((String)k, (List)v);
                } else {
                    ArrayList<String> list = new ArrayList<String>();
                    list.add((String)v);
                    this._paramsMap.put((String)k, (List<String>)list);
                }
            });
        }
        return this._paramsMap;
    }

    public List<UploadedFile> files(String key) throws Exception {
        if (this.isMultipartFormData()) {
            List<UploadedFile> temp = this._fileMap.get(key);
            if (temp == null) {
                return new ArrayList<UploadedFile>();
            }
            return temp;
        }
        return new ArrayList<UploadedFile>();
    }

    public NvMap cookieMap() {
        if (this._cookieMap == null) {
            String[] ss;
            this._cookieMap = new NvMap();
            String tmp = this.header("Cookie", "");
            for (String s : ss = tmp.split(";")) {
                String[] kv = s.split("=");
                if (kv.length > 1) {
                    this._cookieMap.put(kv[0].trim(), (Object)kv[1].trim());
                    continue;
                }
                this._cookieMap.put(kv[0].trim(), null);
            }
        }
        return this._cookieMap;
    }

    public NvMap headerMap() {
        if (this._headerMap == null) {
            this._headerMap = new NvMap();
            Headers headers = this._exchange.getRequestHeaders();
            if (headers != null) {
                headers.forEach((k, l) -> {
                    if (l.size() > 0) {
                        this._headerMap.put(k, l.get(0));
                    }
                });
            }
        }
        return this._headerMap;
    }

    public Object response() {
        return this._exchange;
    }

    protected void contentTypeDoSet(String contentType) {
        if (this.charset != null && contentType.indexOf(";") < 0) {
            this.headerSet("Content-Type", contentType + ";charset=" + this.charset);
            return;
        }
        this.headerSet("Content-Type", contentType);
    }

    public void output(byte[] bytes) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            out.write(bytes);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            OutputStream out = this.outputStream();
            if (!this._allows_write) {
                return;
            }
            byte[] buff = new byte[100];
            int rc = 0;
            while ((rc = stream.read(buff, 0, 100)) > 0) {
                out.write(buff, 0, rc);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public OutputStream outputStream() throws IOException {
        this.sendHeaders();
        if (this._allows_write) {
            return this._exchange.getResponseBody();
        }
        return new ByteArrayOutputStream();
    }

    public void headerSet(String key, String val) {
        this._exchange.getResponseHeaders().set(key, val);
    }

    public void headerAdd(String key, String val) {
        this._exchange.getResponseHeaders().add(key, val);
    }

    public void cookieSet(String key, String val, String domain, String path, int maxAge) {
        StringBuilder sb = new StringBuilder();
        sb.append(key).append("=").append(val).append(";");
        if (Utils.isNotEmpty((String)path)) {
            sb.append("path=").append(path).append(";");
        }
        if (maxAge >= 0) {
            sb.append("max-age=").append(maxAge).append(";");
        }
        if (Utils.isNotEmpty((String)domain)) {
            sb.append("domain=").append(domain.toLowerCase()).append(";");
        }
        this._exchange.getResponseHeaders().add("Set-Cookie", sb.toString());
    }

    public void redirect(String url) {
        this.redirect(url, 302);
    }

    public void redirect(String url, int code) {
        try {
            this.headerSet("Location", url);
            this.statusSet(code);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public int status() {
        return this._status;
    }

    public void statusSet(int status) {
        this._status = status;
    }

    public void flush() throws IOException {
        this.sendHeaders();
        if (this._allows_write) {
            this.outputStream().flush();
        }
    }

    protected void commit() throws IOException {
        this.sendHeaders();
        if (!this._allows_write) {
            this.outputStream().close();
        }
    }

    private void sendHeaders() throws IOException {
        if (!this._headers_sent) {
            this._headers_sent = true;
            if ("HEAD".equals(this.method())) {
                this._allows_write = false;
                this._exchange.sendResponseHeaders(this._status, -1L);
            } else {
                this._exchange.sendResponseHeaders(this._status, 0L);
            }
        }
    }
}

