/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.webservices.integration;

import javax.jws.WebService;
import javax.servlet.ServletConfig;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.web.webservices.WebServiceHelper;
import org.noear.solon.web.webservices.integration.WebServiceBeanBuilder;

public class WebServiceServlet
extends CXFNonSpringServlet {
    protected void loadBus(ServletConfig sc) {
        this.setBus(sc);
        this.publishWebService();
    }

    private void setBus(ServletConfig sc) {
        super.loadBus(sc);
        Bus bus = this.getBus();
        BusFactory.setDefaultBus((Bus)bus);
    }

    private void publishWebService() {
        WebServiceBeanBuilder wsBeanBuilder = (WebServiceBeanBuilder)Solon.context().getBean(WebServiceBeanBuilder.class);
        for (BeanWrap bw : wsBeanBuilder.getWsBeanWarps()) {
            WebService anno = bw.clz().getAnnotation(WebService.class);
            String name = Utils.annoAlias((String)anno.name(), (String)anno.serviceName());
            String wsAddress = this.getAddress(name, bw.clz());
            Class wsImplementClass = bw.clz();
            Object wsImplementInstance = bw.raw();
            WebServiceHelper.publishWebService(wsAddress, wsImplementInstance, wsImplementClass);
        }
    }

    private String getAddress(String value, Class<?> wsInterfaceClass) {
        String address = Utils.isNotEmpty((String)value) ? value : wsInterfaceClass.getSimpleName();
        if (!address.startsWith("/")) {
            address = "/" + address;
        }
        address = address.replaceAll("\\/+", "/");
        return address;
    }
}

