/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.staticfiles.integration;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerPipeline;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.web.staticfiles.StaticConfig;
import org.noear.solon.web.staticfiles.StaticMappings;
import org.noear.solon.web.staticfiles.StaticMimes;
import org.noear.solon.web.staticfiles.StaticResourceHandler;
import org.noear.solon.web.staticfiles.repository.ClassPathStaticRepository;
import org.noear.solon.web.staticfiles.repository.ExtendStaticRepository;
import org.noear.solon.web.staticfiles.repository.FileStaticRepository;

public class XPluginImp
implements Plugin {
    public void start(AppContext context) {
        if (!Solon.app().enableStaticfiles()) {
            return;
        }
        if (!StaticConfig.isEnable()) {
            return;
        }
        StaticConfig.getCacheMaxAge();
        if (ResourceUtil.hasResource((String)"WEB-INF/static/")) {
            StaticMappings.add("/", new ClassPathStaticRepository("WEB-INF/static/"));
        } else if (ResourceUtil.hasResource((String)"static/")) {
            StaticMappings.add("/", new ClassPathStaticRepository("static/"));
        }
        List mapList = (List)Solon.cfg().toBean("solon.staticfiles.mappings", ArrayList.class);
        if (mapList != null) {
            for (Map map : mapList) {
                String path = (String)map.get("path");
                String repository = (String)map.get("repository");
                if (Utils.isEmpty((String)path) || Utils.isEmpty((String)repository)) continue;
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                if (!path.endsWith("/")) {
                    path = path + "/";
                }
                if (repository.startsWith(":")) {
                    StaticMappings.add(path, new ExtendStaticRepository());
                    continue;
                }
                if (ResourceUtil.hasClasspath((String)repository)) {
                    repository = ResourceUtil.remSchema((String)repository);
                    StaticMappings.add(path, new ClassPathStaticRepository(repository));
                    continue;
                }
                StaticMappings.add(path, new FileStaticRepository(repository));
            }
        }
        this.loadStaticMimes();
        HandlerPipeline pipeline = new HandlerPipeline();
        pipeline.next((Handler)new StaticResourceHandler()).next(Solon.app().handlerGet());
        Solon.app().handlerSet((Handler)pipeline);
    }

    private void loadStaticMimes() {
        Solon.cfg().getMap("solon.mime.").forEach((key, val) -> StaticMimes.add("." + key, val));
    }
}

