/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.noear.solon.Solon;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextHolder;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.web.servlet.SolonServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolonServletFilter
implements Filter {
    static final Logger log = LoggerFactory.getLogger(SolonServletFilter.class);
    public static Handler onFilterStart;
    public static Handler onFilterError;
    public static Handler onFilterEnd;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            SolonServletContext ctx = new SolonServletContext((HttpServletRequest)request, (HttpServletResponse)response);
            ContextHolder.currentWith((Context)ctx, () -> this.lambda$doFilter$0((Context)ctx, filterChain, request, response));
        } else {
            filterChain.doFilter(request, response);
        }
    }

    protected void doFilterStart(Context ctx) {
        this.doHandler(onFilterStart, ctx);
    }

    protected void doFilterError(Context ctx) {
        this.doHandler(onFilterError, ctx);
    }

    protected void doFilterEnd(Context ctx) {
        this.doHandler(onFilterEnd, ctx);
    }

    protected void doHandler(Handler h, Context ctx) {
        if (h != null) {
            try {
                h.handle(ctx);
            }
            catch (Throwable e) {
                log.warn(e.getMessage(), e);
            }
        }
    }

    public void destroy() {
    }

    private /* synthetic */ Object lambda$doFilter$0(Context ctx, FilterChain filterChain, ServletRequest request, ServletResponse response) throws RuntimeException {
        try {
            this.doFilterStart(ctx);
            Solon.app().tryHandle(ctx);
            if (!ctx.getHandled() && ctx.status() == 200) {
                filterChain.doFilter(request, response);
            }
            Object var5_5 = null;
            return var5_5;
        }
        catch (Throwable e) {
            ctx.errors = e;
            this.doFilterError(ctx);
            throw new IllegalStateException(e);
        }
        finally {
            this.doFilterEnd(ctx);
        }
    }
}

