/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.servlet;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.web.servlet.holder.FilterAnnoHodler;
import org.noear.solon.web.servlet.holder.ServletAnnoHolder;

public class SolonServletInstaller {
    Set<ServletContainerInitializer> initializers = new LinkedHashSet<ServletContainerInitializer>();
    Set<FilterAnnoHodler> filters = new LinkedHashSet<FilterAnnoHodler>();
    Set<EventListener> listeners = new LinkedHashSet<EventListener>();
    Set<ServletAnnoHolder> servlets = new LinkedHashSet<ServletAnnoHolder>();

    public SolonServletInstaller() {
        Solon.context().beanForeach(bw -> {
            WebListener anno;
            if (bw.raw() instanceof ServletContainerInitializer) {
                this.initializers.add((ServletContainerInitializer)bw.raw());
            }
            if (bw.raw() instanceof EventListener && (anno = bw.clz().getAnnotation(WebListener.class)) != null) {
                this.listeners.add((EventListener)bw.raw());
            }
            if (bw.raw() instanceof Filter && (anno = bw.clz().getAnnotation(WebFilter.class)) != null) {
                this.filters.add(new FilterAnnoHodler((WebFilter)anno, (Filter)bw.raw()));
            }
            if (bw.raw() instanceof Servlet && (anno = bw.clz().getAnnotation(WebServlet.class)) != null) {
                this.servlets.add(new ServletAnnoHolder((WebServlet)anno, (Servlet)bw.raw()));
            }
        });
    }

    public void startup(Set<Class<?>> set, ServletContext sc) throws ServletException {
        String name;
        String[] urlPatterns;
        for (ServletContainerInitializer si : this.initializers) {
            si.onStartup(set, sc);
        }
        for (EventListener l : this.listeners) {
            sc.addListener(l);
        }
        for (FilterAnnoHodler f : this.filters) {
            urlPatterns = f.anno.value();
            if (urlPatterns.length == 0) {
                urlPatterns = f.anno.urlPatterns();
            }
            if (Utils.isEmpty((String)(name = f.anno.filterName()))) {
                name = f.filter.getClass().getSimpleName();
            }
            EnumSet<DispatcherType> enumSet = EnumSet.copyOf(Arrays.asList(f.anno.dispatcherTypes()));
            FilterRegistration.Dynamic dy = sc.addFilter(name, f.filter);
            WebInitParam[] webInitParamArray = f.anno.initParams();
            int n = webInitParamArray.length;
            for (int i = 0; i < n; ++i) {
                WebInitParam ip = webInitParamArray[i];
                dy.setInitParameter(ip.name(), ip.value());
            }
            if (urlPatterns.length > 0) {
                dy.addMappingForUrlPatterns(enumSet, false, urlPatterns);
            }
            if (f.anno.servletNames().length <= 0) continue;
            dy.addMappingForServletNames(enumSet, false, f.anno.servletNames());
        }
        for (ServletAnnoHolder s : this.servlets) {
            urlPatterns = s.anno.value();
            if (urlPatterns.length == 0) {
                urlPatterns = s.anno.urlPatterns();
            }
            if (Utils.isEmpty((String)(name = s.anno.name()))) {
                name = s.servlet.getClass().getSimpleName();
            }
            ServletRegistration.Dynamic dy = sc.addServlet(name, s.servlet);
            for (WebInitParam ip : s.anno.initParams()) {
                dy.setInitParameter(ip.name(), ip.value());
            }
            dy.addMapping(urlPatterns);
            dy.setLoadOnStartup(s.anno.loadOnStartup());
        }
    }
}

