/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ContextAsyncListener;
import org.noear.solon.core.handle.Cookie;
import org.noear.solon.core.handle.UploadedFile;
import org.noear.solon.core.util.IoUtil;
import org.noear.solon.core.util.MultiMap;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.handle.AsyncContextState;
import org.noear.solon.server.handle.ContextBase;
import org.noear.solon.server.util.DecodeUtils;
import org.noear.solon.server.util.RedirectUtils;
import org.noear.solon.web.servlet.AsyncListenerWrap;
import org.noear.solon.web.servlet.MultipartUtil;
import org.noear.solon.web.servlet.SolonServletSessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolonServletContext
extends ContextBase {
    static final Logger log = LoggerFactory.getLogger(SolonServletContext.class);
    private HttpServletRequest _request;
    private HttpServletResponse _response;
    private boolean _loadMultipartFormData = false;
    private URI _uri;
    private String _url;
    private MultiMap<String> _paramMap;
    private MultiMap<String> _cookieMap;
    private MultiMap<String> _headerMap;
    private boolean _headers_sent = false;
    protected final AsyncContextState asyncState = new AsyncContextState();
    private AsyncContext asyncContext;

    public SolonServletContext(HttpServletRequest request, HttpServletResponse response) {
        this._request = request;
        this._response = response;
        if (this.sessionState().replaceable()) {
            this.sessionState = new SolonServletSessionState(request);
        }
    }

    private void loadMultipartFormData() {
        if (this._loadMultipartFormData) {
            return;
        }
        this._loadMultipartFormData = true;
        if (this.isMultipartFormData()) {
            MultipartUtil.buildParamsAndFiles(this, (MultiMap<UploadedFile>)this._fileMap);
        }
    }

    public boolean isHeadersSent() {
        return this._headers_sent;
    }

    public Object pull(Class<?> clz) {
        Object tmp = super.pull(clz);
        if (tmp == null && HttpSession.class.isAssignableFrom(clz)) {
            return this._request.getSession();
        }
        return tmp;
    }

    public Object request() {
        return this._request;
    }

    public String remoteIp() {
        return this._request.getRemoteAddr();
    }

    public int remotePort() {
        return this._request.getRemotePort();
    }

    public String method() {
        return this._request.getMethod();
    }

    public String protocol() {
        return this._request.getProtocol();
    }

    public URI uri() {
        if (this._uri == null) {
            this._uri = URI.create(this.url());
        }
        return this._uri;
    }

    public boolean isSecure() {
        return this._request.isSecure();
    }

    public String url() {
        if (this._url == null) {
            this._url = this._request.getRequestURL().toString();
        }
        return this._url;
    }

    public long contentLength() {
        return this._request.getContentLengthLong();
    }

    public String contentType() {
        return this._request.getContentType();
    }

    public String queryString() {
        return this._request.getQueryString();
    }

    public String body(String charset) throws IOException {
        try {
            return super.body(charset);
        }
        catch (Exception e) {
            throw MultipartUtil.status4xx((Context)this, e);
        }
    }

    public InputStream bodyAsStream() throws IOException {
        return this._request.getInputStream();
    }

    public MultiMap<String> paramMap() {
        this.paramsMapInit();
        return this._paramMap;
    }

    private void paramsMapInit() {
        if (this._paramMap == null) {
            this._paramMap = new MultiMap();
            try {
                DecodeUtils.decodeFormUrlencoded((Context)this);
                if (this.autoMultipart()) {
                    this.loadMultipartFormData();
                }
                for (Map.Entry kv : this._request.getParameterMap().entrySet()) {
                    String name = ServerProps.urlDecode((String)((String)kv.getKey()));
                    this._paramMap.holder(name).setValues((Object[])kv.getValue());
                }
            }
            catch (Exception e) {
                throw MultipartUtil.status4xx((Context)this, e);
            }
        }
    }

    public MultiMap<UploadedFile> fileMap() {
        if (this.isMultipartFormData()) {
            this.loadMultipartFormData();
        }
        return this._fileMap;
    }

    public MultiMap<String> cookieMap() {
        if (this._cookieMap == null) {
            this._cookieMap = new MultiMap(false);
            DecodeUtils.decodeCookies((Context)this, (String)this.header("Cookie"));
        }
        return this._cookieMap;
    }

    public MultiMap<String> headerMap() {
        if (this._headerMap == null) {
            this._headerMap = new MultiMap();
            Enumeration headers = this._request.getHeaderNames();
            while (headers.hasMoreElements()) {
                String key = (String)headers.nextElement();
                this._headerMap.holder(key).setValues(Collections.list(this._request.getHeaders(key)));
            }
        }
        return this._headerMap;
    }

    public Object response() {
        return this._response;
    }

    public void charset(String charset) {
        this._response.setCharacterEncoding(charset);
        this.charset = Charset.forName(charset);
    }

    protected void contentTypeDoSet(String contentType) {
        this._response.setContentType(contentType);
    }

    public OutputStream outputStream() throws IOException {
        this.sendHeaders();
        return this._response.getOutputStream();
    }

    public void output(byte[] bytes) {
        try {
            OutputStream out = this.outputStream();
            out.write(bytes);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void output(InputStream stream) {
        try {
            OutputStream out = this.outputStream();
            IoUtil.transferTo((InputStream)stream, (OutputStream)out);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public void headerSet(String key, String val) {
        this._response.setHeader(key, val);
    }

    public void headerAdd(String key, String val) {
        this._response.addHeader(key, val);
    }

    public String headerOfResponse(String name) {
        return this._response.getHeader(name);
    }

    public Collection<String> headerValuesOfResponse(String name) {
        return this._response.getHeaders(name);
    }

    public Collection<String> headerNamesOfResponse() {
        return this._response.getHeaderNames();
    }

    public void cookieSet(Cookie cookie) {
        javax.servlet.http.Cookie c = new javax.servlet.http.Cookie(cookie.name, cookie.value);
        if (cookie.maxAge >= 0) {
            c.setMaxAge(cookie.maxAge);
        }
        if (Utils.isNotEmpty((String)cookie.domain)) {
            c.setDomain(cookie.domain);
        }
        if (Utils.isNotEmpty((String)cookie.path)) {
            c.setPath(cookie.path);
        }
        c.setSecure(cookie.secure);
        c.setHttpOnly(cookie.httpOnly);
        this._response.addCookie(c);
    }

    public void redirect(String url, int code) {
        url = RedirectUtils.getRedirectPath((String)url);
        this.headerSet("Location", url);
        this.statusDoSet(code);
    }

    public int status() {
        return this._response.getStatus();
    }

    protected void statusDoSet(int status) {
        this._response.setStatus(status);
    }

    public void flush() throws IOException {
        this.outputStream().flush();
    }

    public void close() throws IOException {
        this.outputStream().close();
    }

    protected void innerCommit() throws IOException {
        if (this.getHandled() || this.status() >= 200) {
            this.sendHeaders();
        } else {
            this._response.setStatus(404);
        }
    }

    private void sendHeaders() throws IOException {
        if (!this._headers_sent) {
            this._headers_sent = true;
            if (this.sessionState() != null) {
                this.sessionState().sessionPublish();
            }
        }
    }

    public boolean asyncSupported() {
        return true;
    }

    public boolean asyncStarted() {
        return this.asyncContext != null;
    }

    public void asyncListener(ContextAsyncListener listener) {
        this.asyncState.addListener(listener);
    }

    public void asyncStart(long timeout, Runnable runnable) {
        if (this.asyncContext == null) {
            this.asyncContext = this._request.startAsync();
            this.asyncState.isStarted = true;
            this.asyncContext.addListener((AsyncListener)new AsyncListenerWrap((Context)this, (ContextAsyncListener)this.asyncState));
            if (timeout != 0L) {
                this.asyncContext.setTimeout(timeout);
            }
            if (runnable != null) {
                this.asyncContext.start(runnable);
            }
        }
    }

    public void asyncComplete() {
        if (this.asyncContext != null) {
            try {
                this.innerCommit();
            }
            catch (Throwable e) {
                log.warn("Async completion failed", e);
                this.asyncState.onError((Context)this, e);
            }
            finally {
                this.asyncContext.complete();
            }
        }
    }
}

