/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.rx.handle;

import org.noear.solon.core.handle.Entity;
import reactor.core.publisher.Mono;

public class RxEntity {
    private final Entity entity;

    private RxEntity(int code) {
        this.entity = new Entity().status(code);
    }

    public RxEntity headerAdd(String name, String value) {
        this.entity.headerAdd(name, value);
        return this;
    }

    public RxEntity headerRemove(String name) {
        this.entity.headerRemove(name);
        return this;
    }

    public RxEntity headerSet(String name, String value) {
        this.entity.headerSet(name, value);
        return this;
    }

    public RxEntity contentType(String contentType) {
        this.entity.contentType(contentType);
        return this;
    }

    public Mono<Entity> body(Object body) {
        this.entity.body(body);
        return Mono.just((Object)this.entity);
    }

    public Mono<Entity> build() {
        return Mono.just((Object)this.entity);
    }

    public static RxEntity ok() {
        return new RxEntity(200);
    }

    public static RxEntity badRequest() {
        return new RxEntity(400);
    }

    public static RxEntity notFound() {
        return new RxEntity(404);
    }

    public static RxEntity accepted() {
        return new RxEntity(202);
    }

    public static RxEntity status(int code) {
        return new RxEntity(code);
    }
}

