/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.rx.integration;

import org.noear.solon.core.handle.Context;
import org.noear.solon.rx.CompletableEmitter;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RxSubscriberImpl
implements Subscriber {
    static final Logger log = LoggerFactory.getLogger(RxSubscriberImpl.class);
    private Context ctx;
    private boolean isStreaming;
    private CompletableEmitter completableEmitter;
    private Subscription subscription;
    private static final byte[] CRLF = "\n".getBytes();

    public RxSubscriberImpl(Context ctx, boolean isStreaming, CompletableEmitter completableEmitter) {
        this.ctx = ctx;
        this.isStreaming = isStreaming;
        this.completableEmitter = completableEmitter;
    }

    public void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        if (this.ctx.asyncStarted()) {
            subscription.request(1L);
        } else {
            this.ctx.asyncStart(-1L, () -> subscription.request(1L));
        }
    }

    public void onNext(Object o) {
        try {
            this.ctx.render(o);
            if (this.isStreaming) {
                this.ctx.output(CRLF);
                this.ctx.flush();
            }
            if (this.subscription != null) {
                this.subscription.request(1L);
            }
        }
        catch (Throwable e) {
            this.onError(e);
        }
    }

    public void onError(Throwable e) {
        try {
            this.completableEmitter.onError(e);
        }
        finally {
            if (this.subscription != null) {
                this.subscription.cancel();
            }
        }
    }

    public void onComplete() {
        this.completableEmitter.onComplete();
    }
}

