/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.rx.handle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.rx.Completable;
import org.noear.solon.rx.handle.RxFilter;
import org.noear.solon.rx.handle.RxFilterChainImpl;
import org.noear.solon.rx.handle.RxHandler;

public class RxChainManager<CTX> {
    private final Set<Class<?>> typeSet = new HashSet();
    private final List<RankEntity<RxFilter<CTX>>> filterNodes = new ArrayList<RankEntity<RxFilter<CTX>>>();
    private final ReentrantLock SYNC_LOCK = new ReentrantLock();

    public Collection<RxFilter<CTX>> getFilterNodes() {
        ArrayList<RxFilter<CTX>> tmp = new ArrayList<RxFilter<CTX>>();
        for (RankEntity<RxFilter<CTX>> entity : this.filterNodes) {
            tmp.add((RxFilter<CTX>)entity.target);
        }
        return tmp;
    }

    public void addFilter(RxFilter<CTX> filter, int index) {
        this.SYNC_LOCK.lock();
        try {
            this.typeSet.add(filter.getClass());
            this.filterNodes.add(new RankEntity(filter, index));
            Collections.sort(this.filterNodes);
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public void addFilterIfAbsent(RxFilter<CTX> filter, int index) {
        this.SYNC_LOCK.lock();
        try {
            if (this.typeSet.contains(filter.getClass())) {
                return;
            }
            this.typeSet.add(filter.getClass());
            this.filterNodes.add(new RankEntity(filter, index));
            this.filterNodes.sort(Comparator.comparingInt(f -> f.index));
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public Completable doFilter(CTX x, RxHandler<CTX> lastHandler) throws Throwable {
        return new RxFilterChainImpl<CTX>(this.filterNodes, lastHandler).doFilter(x);
    }
}

