/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.rx.integration;

import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.Context;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionRxSubscriber
implements Subscriber {
    static final Logger log = LoggerFactory.getLogger(ActionRxSubscriber.class);
    private Context ctx;
    private Action action;
    private boolean isStreaming;
    private static final byte[] CRLF = "\n".getBytes();

    public ActionRxSubscriber(Context ctx, Action action, boolean isStreaming) {
        this.ctx = ctx;
        this.action = action;
        this.isStreaming = isStreaming;
    }

    private void request(Subscription subscription) {
        subscription.request(Long.MAX_VALUE);
    }

    public void onSubscribe(Subscription subscription) {
        if (this.ctx.asyncStarted()) {
            this.request(subscription);
        } else {
            this.ctx.asyncStart(-1L, () -> this.request(subscription));
        }
    }

    public void onNext(Object o) {
        try {
            this.action.render(o, this.ctx, true);
            if (this.isStreaming) {
                this.ctx.output(CRLF);
                this.ctx.flush();
            }
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    public void onError(Throwable e) {
        try {
            this.action.render((Object)e, this.ctx, false);
        }
        catch (Throwable e2) {
            this.ctx.status(500);
            log.warn(e.getMessage(), e);
        }
        finally {
            this.onComplete();
        }
    }

    public void onComplete() {
        if (this.ctx.asyncSupported()) {
            this.ctx.asyncComplete();
        }
    }
}

