/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.view.thymeleaf;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.ModelAndView;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.core.util.SupplierEx;
import org.noear.solon.server.ServerProps;
import org.noear.solon.server.util.DebugUtils;
import org.noear.solon.view.ViewConfig;
import org.noear.solon.view.thymeleaf.BaseUrlLinkBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.IThrottledTemplateProcessor;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.TemplateSpec;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.linkbuilder.ILinkBuilder;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ThymeleafRender
implements Render {
    static final Logger log = LoggerFactory.getLogger(ThymeleafRender.class);
    private final ClassLoader classLoader;
    private final String viewPrefix;
    private Map<String, Object> sharedVariables = new HashMap<String, Object>();
    private TemplateEngine provider = new TemplateEngine();

    public TemplateEngine getProvider() {
        return this.provider;
    }

    public ThymeleafRender() {
        this((ClassLoader)AppClassLoader.global(), null);
    }

    public ThymeleafRender(ClassLoader classLoader) {
        this(classLoader, null);
    }

    public ThymeleafRender(ClassLoader classLoader, String viewPrefix) {
        this.classLoader = classLoader;
        this.viewPrefix = viewPrefix == null ? ViewConfig.getViewPrefix() : viewPrefix;
        this.forDebug();
        this.forRelease();
    }

    private void forDebug() {
        if (!Solon.cfg().isDebugMode()) {
            return;
        }
        if (!Solon.cfg().isFilesMode()) {
            return;
        }
        if (ResourceUtil.hasFile((String)this.viewPrefix)) {
            return;
        }
        File dir = DebugUtils.getDebugLocation((ClassLoader)this.classLoader, (String)this.viewPrefix);
        if (dir == null) {
            return;
        }
        try {
            if (dir.exists()) {
                FileTemplateResolver _loader = new FileTemplateResolver();
                _loader.setPrefix(dir.getPath() + File.separatorChar);
                _loader.setTemplateMode(TemplateMode.HTML);
                _loader.setCacheable(false);
                _loader.setCharacterEncoding("utf-8");
                _loader.setCacheTTLMs(Long.valueOf(3600000L));
                this.provider.addTemplateResolver((ITemplateResolver)_loader);
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    private void forRelease() {
        if (ResourceUtil.hasFile((String)this.viewPrefix)) {
            URL dir = ResourceUtil.findResource((ClassLoader)this.classLoader, (String)this.viewPrefix, (boolean)false);
            FileTemplateResolver _loader = new FileTemplateResolver();
            _loader.setPrefix(dir.getFile() + File.separatorChar);
            _loader.setTemplateMode(TemplateMode.HTML);
            _loader.setCharacterEncoding("utf-8");
            _loader.setCacheTTLMs(Long.valueOf(3600000L));
            this.provider.addTemplateResolver((ITemplateResolver)_loader);
        } else {
            ClassLoaderTemplateResolver _loader = new ClassLoaderTemplateResolver(this.classLoader);
            _loader.setPrefix(this.viewPrefix);
            _loader.setTemplateMode(TemplateMode.HTML);
            _loader.setCacheable(true);
            _loader.setCharacterEncoding("utf-8");
            _loader.setCacheTTLMs(Long.valueOf(3600000L));
            this.provider.addTemplateResolver((ITemplateResolver)_loader);
        }
        String baseUrl = Solon.cfg().serverContextPath();
        if (Utils.isEmpty((String)baseUrl)) {
            baseUrl = "";
        } else if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        BaseUrlLinkBuilder baseUrlLinkBuilder = new BaseUrlLinkBuilder();
        baseUrlLinkBuilder.setBaseUrl(baseUrl);
        this.provider.setLinkBuilder((ILinkBuilder)baseUrlLinkBuilder);
    }

    public <T extends IDialect> void putDirective(T obj) {
        try {
            this.provider.addDialect(obj);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void putVariable(String name, Object obj) {
        this.sharedVariables.put(name, obj);
    }

    public void render(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return;
        }
        if (obj instanceof ModelAndView) {
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> ctx.outputStream()));
        } else {
            ctx.output(obj.toString());
        }
    }

    public String renderAndReturn(Object obj, Context ctx) throws Throwable {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ModelAndView) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            this.render_mav((ModelAndView)obj, ctx, (SupplierEx<OutputStream>)((SupplierEx)() -> outputStream));
            return outputStream.toString();
        }
        return obj.toString();
    }

    public void render_mav(ModelAndView mv, Context ctx, SupplierEx<OutputStream> outputStream) throws Throwable {
        if (ctx.contentTypeNew() == null) {
            ctx.contentType("text/html;charset=UTF-8");
        }
        if (ViewConfig.isOutputMeta()) {
            ctx.headerSet("Solon-View", "ThymeleafRender");
        }
        mv.putIfAbsent("context", (Object)ctx);
        org.thymeleaf.context.Context context = new org.thymeleaf.context.Context();
        context.setVariables(this.sharedVariables);
        context.setVariables(mv.model());
        if (ctx.getLocale() != null) {
            context.setLocale(ctx.getLocale());
        }
        TemplateSpec templateSpec = new TemplateSpec(mv.view(), TemplateMode.HTML);
        IThrottledTemplateProcessor templateProcessor = this.provider.processThrottled(templateSpec, (IContext)context);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream.get(), ServerProps.response_encoding));
        templateProcessor.processAll((Writer)writer);
        writer.flush();
    }
}

