/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.statemachine;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.noear.solon.core.util.Assert;
import org.noear.solon.lang.Preview;
import org.noear.solon.statemachine.StateTransitionContext;

@Preview(value="3.4")
public class StateTransitionDecl<S, E, T> {
    protected List<S> source;
    protected S target;
    protected E event;
    protected Predicate<StateTransitionContext<S, E, T>> condition;
    protected Consumer<StateTransitionContext<S, E, T>> action;

    protected void check() {
        Assert.notNull(this.source, (String)"The source state(from) cannot be null");
        Assert.notNull(this.target, (String)"The target state(to) cannot be null");
        Assert.notNull(this.event, (String)"The on(event) cannot be null");
        if (this.condition == null) {
            this.condition = c -> true;
        }
        if (this.action == null) {
            this.action = c -> {};
        }
    }

    public StateTransitionDecl<S, E, T> from(S ... source) {
        Assert.notNull(source, (String)"The source state(from) cannot be null");
        this.source = Arrays.asList(source);
        return this;
    }

    public StateTransitionDecl<S, E, T> to(S target) {
        Assert.notNull(target, (String)"The target state(to) cannot be null");
        this.target = target;
        return this;
    }

    public StateTransitionDecl<S, E, T> on(E event) {
        Assert.notNull(event, (String)"The on(event) cannot be null");
        this.event = event;
        return this;
    }

    public StateTransitionDecl<S, E, T> when(Predicate<StateTransitionContext<S, E, T>> condition) {
        this.condition = condition;
        return this;
    }

    public StateTransitionDecl<S, E, T> then(Consumer<StateTransitionContext<S, E, T>> action) {
        this.action = action;
        return this;
    }
}

