/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.statemachine;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.solon.lang.Preview;
import org.noear.solon.statemachine.Event;
import org.noear.solon.statemachine.State;
import org.noear.solon.statemachine.StateContext;
import org.noear.solon.statemachine.StateTransition;

@Preview(value="3.4")
public class StateMachine<S extends State, E extends Event, T> {
    private S currentState;
    private final List<StateTransition<S, E, T>> transitions = new ArrayList<StateTransition<S, E, T>>();
    private final ReentrantLock LOCKER = new ReentrantLock();

    public StateMachine(S initState) {
        this.currentState = initState;
    }

    public void addTransition(StateTransition<S, E, T> transition) {
        this.transitions.add(transition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(E event, T payload) {
        this.LOCKER.lock();
        try {
            for (StateTransition<S, E, T> transition : this.transitions) {
                if (!transition.matches(this.currentState, event, payload)) continue;
                S from = this.currentState;
                S to = transition.getTo();
                this.currentState = to;
                transition.execute(new StateContext<S, E, T>(from, to, event, payload));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.LOCKER.unlock();
        }
    }

    public boolean execute(E event) {
        return this.execute(event, null);
    }

    public S getCurrentState() {
        return this.currentState;
    }

    public void restore(S state) {
        this.currentState = state;
    }
}

