/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.sessionstate.jwt;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.security.Keys;
import java.security.Key;
import java.util.Date;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.SecretKey;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.sessionstate.jwt.JwtSessionProps;
import org.noear.solon.sessionstate.jwt.JwtSessionStateFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwtUtils {
    static final Logger log = LoggerFactory.getLogger(JwtUtils.class);
    private static String TOKEN_HEADER = "Bearer ";
    private static Key key = null;
    private static final ReentrantLock SYNC_LOCK = new ReentrantLock();

    private static Key getKey() {
        if (key == null) {
            SYNC_LOCK.lock();
            try {
                if (key == null) {
                    String signKey0 = JwtSessionStateFactory.getInstance().signKey();
                    key = Keys.hmacShaKeyFor((byte[])((byte[])Decoders.BASE64.decode((Object)signKey0)));
                }
            }
            finally {
                SYNC_LOCK.unlock();
            }
        }
        return key;
    }

    public static String createKey() {
        SecretKey key = Keys.secretKeyFor((SignatureAlgorithm)SignatureAlgorithm.HS256);
        return (String)Encoders.BASE64.encode((Object)key.getEncoded());
    }

    public static String buildJwt(Claims claims, long expire) {
        return JwtUtils.buildJwt(claims, expire, JwtUtils.getKey());
    }

    public static String buildJwt(Claims claims, long expire, Key signKey) {
        JwtBuilder builder = expire > 0L ? Jwts.builder().setClaims(claims).setIssuedAt(new Date()).setExpiration(new Date(System.currentTimeMillis() + expire)) : Jwts.builder().setClaims(claims).setIssuedAt(new Date());
        if (Utils.isNotEmpty((String)Solon.cfg().appName())) {
            builder.setIssuer(Solon.cfg().appName());
        }
        if (Utils.isNotEmpty((String)JwtSessionProps.getInstance().prefix)) {
            return JwtSessionProps.getInstance().prefix + " " + builder.signWith(signKey).compact();
        }
        return builder.signWith(signKey).compact();
    }

    public static Claims parseJwt(String token) {
        return JwtUtils.parseJwt(token, JwtUtils.getKey());
    }

    public static Claims parseJwt(String token, Key signKey) {
        if (token.startsWith(TOKEN_HEADER)) {
            token = token.substring(TOKEN_HEADER.length()).trim();
        }
        if (Utils.isNotEmpty((String)JwtSessionProps.getInstance().prefix) && token.startsWith(JwtSessionProps.getInstance().prefix)) {
            token = token.substring(JwtSessionProps.getInstance().prefix.length()).trim();
        }
        try {
            return (Claims)Jwts.parserBuilder().setSigningKey(signKey).build().parseClaimsJws(token).getBody();
        }
        catch (ExpiredJwtException expiredJwtException) {
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
        return null;
    }
}

