/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.sessionstate.jedis;

import java.util.Properties;
import org.noear.redisx.RedisClient;
import org.noear.solon.Solon;
import org.noear.solon.core.Props;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.SessionState;
import org.noear.solon.core.handle.SessionStateFactory;
import org.noear.solon.sessionstate.jedis.JedisSessionState;

public class JedisSessionStateFactory
implements SessionStateFactory {
    private static JedisSessionStateFactory instance;
    private RedisClient redisClient;
    public static final int SESSION_STATE_PRIORITY = 2;

    public static JedisSessionStateFactory getInstance() {
        if (instance == null) {
            instance = new JedisSessionStateFactory();
        }
        return instance;
    }

    private JedisSessionStateFactory() {
        Props prop = Solon.cfg().getProp("server.session.state.redis");
        if (prop.size() < 4) {
            System.err.println("Error configuration: solon.session.state.redis");
            return;
        }
        this.redisClient = new RedisClient((Properties)prop);
    }

    public RedisClient redisClient() {
        return this.redisClient;
    }

    public int priority() {
        return 2;
    }

    public SessionState create(Context ctx) {
        return new JedisSessionState(ctx);
    }
}

