/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.server.handle;

import org.noear.solon.Utils;
import org.noear.solon.core.handle.Context;
import org.noear.solon.core.handle.Cookie;
import org.noear.solon.core.handle.SessionState;
import org.noear.solon.server.handle.SessionProps;

public abstract class SessionStateBase
implements SessionState {
    protected static final int _expiry = SessionProps.session_timeout;
    protected static final String _domain = SessionProps.session_cookieDomain;
    protected static final boolean _httpOnly = SessionProps.session_cookieHttpOnly;
    protected final Context ctx;

    protected SessionStateBase(Context ctx) {
        this.ctx = ctx;
    }

    protected String cookieGet(String key) {
        return this.ctx.cookie(key);
    }

    protected void cookieSet(String key, String val) {
        if (this.ctx.url() == null) {
            return;
        }
        Cookie sessionCookie = new Cookie(key, val).domain(_domain).maxAge(_expiry).httpOnly(_httpOnly);
        if (SessionProps.session_cookieDomainAuto && _domain != null && this.ctx.uri().getHost().indexOf(_domain) < 0) {
            sessionCookie.domain(null);
        }
        this.ctx.cookieSet(sessionCookie);
    }

    protected String sessionIdGet(boolean reset) {
        String sid = this.cookieGet(SessionProps.session_cookieName);
        if (!reset && !Utils.isEmpty((String)sid) && sid.length() > 30) {
            return sid;
        }
        sid = Utils.guid();
        this.cookieSet(SessionProps.session_cookieName, sid);
        this.ctx.cookieMap().put(SessionProps.session_cookieName, (Object)sid);
        return sid;
    }

    protected String sessionIdPush() {
        String sid = this.cookieGet(SessionProps.session_cookieName);
        if (Utils.isNotEmpty((String)sid)) {
            this.cookieSet(SessionProps.session_cookieName, sid);
        }
        return sid;
    }
}

